package com.digiwin.athena.actuator;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.http.esp.EspApiHelper;
import com.digiwin.athena.http.esp.EspParamDto;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.JSUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class EspActuator {

    @Autowired
    private EspApiHelper espApiHelper;

    public Object execute(EspExecuteConfig config, Map<String, Object> requestParams) {

        JSONObject requestContext = new JSONObject();
        requestContext.put("body",requestParams);
        requestContext.put("espActionId",config.getEspActionId());

        if (!StringUtils.isEmpty(config.getRequestScript())) {
            JSUtil.evalRequest(config.getRequestScript(), requestContext);
        }

        TenantInfo curTokenTenant = CurThreadInfoUtils.getCurTokenTenant();
        EspParamDto<Object> res = espApiHelper.callEspService(requestContext.get("body"), requestContext.getString("url"), CurThreadInfoUtils.getToken(), curTokenTenant.getTenantId(), config.getServiceCode());

        if (!StringUtils.isEmpty(config.getResponseScript())) {
            return JSUtil.evalResponse(config.getResponseScript(), JSONObject.toJSONString(res), Map.class);
        }
        return res;
    }
}
