package com.digiwin.athena.controller;

import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.mongodb.domain.other.PresetData;
import com.digiwin.athena.sys.PresetDataServiceV2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/productJS")
public class ProductJSConfigController {
    @Autowired
    private PresetDataServiceV2 presetDataServiceV2;

    @GetMapping("/getProductJS")
    public ResultDto<PresetData> getProjectJS(String product){
        PresetData res = presetDataServiceV2.getPresetDataObjectV2("JS_TEMPLATE_" + product);
        if (res==null){
            PresetData jsTemplateT100 = presetDataServiceV2.getPresetDataObjectV2("JS_TEMPLATE_T100");
            return ResultDto.createSuccess(jsTemplateT100);
        }
        return ResultDto.createSuccess(res);
    }
}
