/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.codeStandard;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.service.codeStandard.CodeGeneratorService;
import com.digiwin.athena.service.codeStandard.dto.GenerateCodeDto;
import com.digiwin.athena.utils.MD5;
import com.digiwin.athena.utils.SnowflakeToHexStrUtil;
import java.util.HashMap;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BuildGeneratorCodeUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuildGeneratorCodeUtil.class);
    @Autowired
    private CodeGeneratorService codeGeneratorService;

    public String createStandardCodeOfEvent(String application, String endCode, String autoOrCustom) {
        try {
            GenerateCodeDto dto = new GenerateCodeDto();
            dto.setTypeCode("event");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("application", application);
            map.put(autoOrCustom, "");
            map.put("inputCode", endCode);
            dto.setParamMap(map);
            return this.codeGeneratorService.generateCode(dto);
        }
        catch (Exception e) {
            log.error("\u4e8b\u4ef6\u751f\u6210\u6807\u51c6\u5316code\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\u4e3a:{}", (Object)e.getMessage(), (Object)e);
            throw new BusinessException("\u4e8b\u4ef6\u751f\u6210\u6807\u51c6\u5316code\u5f02\u5e38:" + e.getMessage());
        }
    }

    public String createStandardCode(String application, String type) {
        try {
            GenerateCodeDto dto = new GenerateCodeDto();
            dto.setTypeCode("default");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("application", application);
            map.put("abbreviationCode", type);
            map.put("inputCode", SnowflakeToHexStrUtil.snowflakeToHex());
            dto.setParamMap(map);
            return this.codeGeneratorService.generateCode(dto);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u6807\u51c6\u5316code\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\u4e3a:{},\u5bf9\u5e94\u7c7b\u578b\u4e3a:{}", new Object[]{e.getMessage(), type, e});
            throw new BusinessException("\u751f\u6210\u6807\u51c6\u5316code\u5f02\u5e38:" + e.getMessage());
        }
    }

    public String createStandardCodeDataView(String application, String type, String inputCode) {
        try {
            GenerateCodeDto dto = new GenerateCodeDto();
            dto.setTypeCode("default");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("application", application);
            map.put("abbreviationCode", type);
            map.put("inputCode", inputCode);
            dto.setParamMap(map);
            return this.codeGeneratorService.generateCode(dto);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u65b9\u6848\u751f\u6210\u6807\u51c6\u5316code\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\u4e3a:{}", (Object)e.getMessage(), (Object)e);
            throw new BusinessException("\u67e5\u8be2\u65b9\u6848\u751f\u6210\u6807\u51c6\u5316code\u5f02\u5e38:" + e);
        }
    }

    public String individualCase(String application, String type) {
        return "UC_" + this.createStandardCode(application, type);
    }

    public String createStandardCodeConfig(String tenantId, String type) {
        try {
            GenerateCodeDto dto = new GenerateCodeDto();
            dto.setTypeCode("customConfig");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("tenantId", tenantId);
            map.put("abbreviationCode", type);
            map.put("inputCode", SnowflakeToHexStrUtil.snowflakeToHex());
            dto.setParamMap(map);
            return this.codeGeneratorService.generateCode(dto);
        }
        catch (Exception e) {
            log.error("\u516c\u6709\u7684\u5b9a\u5236\u914d\u7f6e\u751f\u6210\u6807\u51c6\u5316code\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\u4e3a:{},\u5bf9\u5e94\u7c7b\u578b\u4e3a:{}", new Object[]{e.getMessage(), type, e});
            throw new BusinessException("\u516c\u6709\u7684\u5b9a\u5236\u914d\u7f6e\u751f\u6210\u6807\u51c6\u5316code\u5f02\u5e38:" + e.getMessage());
        }
    }

    public String createAssetId(String code, String type) {
        String md5 = MD5.getMD5((String)(code + "_" + type));
        return "AT_" + MD5.getMD5((String)md5).substring(0, 16);
    }

    public String generateActivityCode(String type) {
        String uuid = UUID.randomUUID().toString();
        switch (type) {
            case "manual": 
            case "invokeSubProject": {
                return "StartSubProjectNode_" + uuid;
            }
            case "sendMessage": {
                return "SendMessage_" + uuid;
            }
            case "getAllUsers": {
                return "GetAllUsers_" + uuid;
            }
            case "esp": {
                return "InvokeEsp_" + uuid;
            }
            case "http": {
                return "HttpNode_" + uuid;
            }
            case "composite": {
                return "GroupByData_" + uuid;
            }
            case "notice": {
                return "Notice_" + uuid;
            }
            case "script": {
                return "ScriptNode_" + uuid;
            }
            case "approve": {
                return "ApproveNode_" + uuid;
            }
            case "createData": {
                return "DataGroup_" + uuid;
            }
            case "wait": {
                return "WaitingNode_" + uuid;
            }
            case "groovy": {
                return "GroovyNode_" + uuid;
            }
        }
        log.info("\u5f53\u524d\u5e94\u7528\u6ca1\u6709\u5339\u914d\u5230\u7c7b\u578b:{}", (Object)type);
        return type + "_" + uuid;
    }
}

