package com.digiwin.athena.dao;

import com.digiwin.athena.mongodb.domain.appCustomConfig.ApplicationCustomConfig;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.stream.Collectors;


@Slf4j
@Repository
public class RApplicationCustomConfigMongoDao {

    @Autowired
    private MongoRuntimeRepositoryDecorator mongoRuntimeRepositoryDecorator;

    public void insert(ApplicationCustomConfig applicationCustomConfig) {
        mongoRuntimeRepositoryDecorator.insert(applicationCustomConfig);
    }

    public void deleteByAdpCodeAndApp(String adpCode, String application) {
        Criteria criteria = Criteria.where("adpCode").in(adpCode).and("application").is(application);
        mongoRuntimeRepositoryDecorator.delete(new Query(criteria), ApplicationCustomConfig.class);
    }

    public void deleteByAdpCodesAndApp(List<String> adpCodes, String adpApplication) {
        Criteria criteria = Criteria.where("adpCode").in(adpCodes).and("application").is(adpApplication);
        mongoRuntimeRepositoryDecorator.delete(new Query(criteria), ApplicationCustomConfig.class);
    }

    public List<ApplicationCustomConfig> selectByAdpCodesAndApp(List<String> adpCodes, String application) {
        Criteria criteria = Criteria.where("adpCode").in(adpCodes).and("application").is(application);
        return mongoRuntimeRepositoryDecorator.find(new Query(criteria), ApplicationCustomConfig.class);
    }

    public List<String> selectAdpCodesByApp(String application) {
        Criteria criteria = Criteria.where("application").in(application);
        Query query = new Query(criteria);
        query.fields().include("adpCode");
        return mongoRuntimeRepositoryDecorator.find(query, ApplicationCustomConfig.class).stream().map(ApplicationCustomConfig::getAdpCode).collect(Collectors.toList());
    }

    public void deleteByApplication(String appCode) {
        Criteria criteria = Criteria.where("application").is(appCode);
        mongoRuntimeRepositoryDecorator.delete(new Query(criteria),ApplicationCustomConfig.class);
    }
}
