package com.digiwin.athena.mongodb.domain.appCustomConfig;


import com.digiwin.athena.constant.Constant;
import com.digiwin.athena.mongodb.domain.appCustomConfig.CustomControlRes;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Document(collection = "sysApplicationCustomizedConfig")
public class SysApplicationCustomConfig {

    @Id
    private String id;

    /**
     * 插件名称
     */
    private String name;
    /**
     * 插件描述
     */
    private String description;
    /**
     * 定制包路径
     */
    private String path;
    /**
     * 定制包打包后的chunk名称
     */
    private String chunkName;
    /**
     * 是否为微前端
     */
    private boolean isMF;
    /**
     * 租户id
     */
    private String tenantId= Constant.SYSTEM;

    /**
     * 微前端中被导出的模块名称
     */
    private String remoteName;
    /**
     *微前端中被导出的模块路径
     */
    private String exposedModule;

    private Map<String, Map<String, String>> lang;

    private String createBy;
    private Date createDate;
    private String editBy;
    private Date editDate;

    private String adpTenantId;

    private List<CustomControlRes> customControl=new ArrayList<>();

    private String adpCode;

    public String getAdpCode() {
        return adpCode;
    }

    public void setAdpCode(String adpCode) {
        this.adpCode = adpCode;
    }

    public List<CustomControlRes> getCustomControl() {
        return customControl;
    }

    public void setCustomControl(List<CustomControlRes> customControl) {
        this.customControl = customControl;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getChunkName() {
        return chunkName;
    }

    public void setChunkName(String chunkName) {
        this.chunkName = chunkName;
    }

    public Boolean getIsMF() {
        return isMF;
    }

    public void setIsMF(Boolean MF) {
        isMF = MF;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getRemoteName() {
        return remoteName;
    }

    public void setRemoteName(String remoteName) {
        this.remoteName = remoteName;
    }

    public String getExposedModule() {
        return exposedModule;
    }

    public void setExposedModule(String exposedModule) {
        this.exposedModule = exposedModule;
    }

    public Map<String, Map<String, String>> getLang() {
        return lang;
    }

    public void setLang(Map<String, Map<String, String>> lang) {
        this.lang = lang;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getEditBy() {
        return editBy;
    }

    public void setEditBy(String editBy) {
        this.editBy = editBy;
    }

    public Date getEditDate() {
        return editDate;
    }

    public void setEditDate(Date editDate) {
        this.editDate = editDate;
    }

    public String getAdpTenantId() {
        return adpTenantId;
    }

    public void setAdpTenantId(String adpTenantId) {
        this.adpTenantId = adpTenantId;
    }
}
