/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.appCustomConfig.event;

import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.service.appCustomConfig.CustomControlEventListener;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CustomControlEventManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomControlEventManager.class);
    private static Map<EvenType, List<CustomControlEventListener>> listeners = new HashMap<EvenType, List<CustomControlEventListener>>();

    public CustomControlEventManager() {
        for (EvenType value : EvenType.values()) {
            listeners.put(value, new ArrayList());
        }
    }

    public void registerListener(EvenType type, CustomControlEventListener customControlEventListener) {
        if (!listeners.containsKey((Object)type)) {
            throw new BusinessException(String.valueOf((Object)type) + " not exists");
        }
        listeners.get((Object)type).add(customControlEventListener);
    }

    public void notify(EvenType type, Object obj) {
        if (obj == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)CurThreadInfoUtils.getTemplateId())) {
            for (CustomControlEventListener customControlEventListener : listeners.get((Object)type)) {
                customControlEventListener.doEvent(obj);
            }
        }
    }

    public static enum EvenType {
        PROJECT("Project"),
        TASK("Task"),
        DATA_ENTRY("DataEntry"),
        REPORT("Report"),
        PROCESS("Process"),
        NEW_PAGE_DESIGN("NewPageDesign");

        private String code;

        private EvenType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

