package com.digiwin.athena.service.codeStandard.impl;

import com.digiwin.athena.service.codeStandard.CodeGenerateHandler;
import org.springframework.stereotype.Service;

import java.security.SecureRandom;
import java.util.Map;

/**
 * 自动生成code 0-9 a-z A-Z
 */
@Service("autoCodeGenerateHandler")
public class AutoCodeGenerateHandler implements CodeGenerateHandler {

    private static final String CHARACTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final SecureRandom secureRandom = new SecureRandom();


    /**
     * 返回格式 _BN_
     */
    @Override
    public String generateCode(Map<String, String> params, Map<String, String> param) {

        // 自动生成的 code 长度 如果为空 默认为 8位
        String codeLengthStr = params.getOrDefault("len", "8");
        String characters = params.getOrDefault("characters", CHARACTERS);

        int length;
        try {
            length = Integer.parseInt(codeLengthStr);
        } catch (NumberFormatException e) {
            length = 8; // 默认长度
        }

        return generateRandomString(length, characters);

    }



    /**
     * 生成固定长度的字符串
     *
     * @param length 长度
     * @param characters 字符范围
     */
    public static String generateRandomString(int length, String characters) {
        if (length <= 0 || characters.isEmpty()) {
            throw new IllegalArgumentException("Length must be positive and characters cannot be empty");
        }

        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; i++) {
            int index = secureRandom.nextInt(characters.length());
            sb.append(characters.charAt(index));
        }
        return sb.toString();
    }

}
