package com.digiwin.athena.actuator;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.http.asset.ThirdPartyApiHelper;
import com.digiwin.athena.utils.JSUtil;
import com.digiwin.athena.utils.expression.ExpressionUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
@Slf4j
public class HttpActuator {
    @Autowired
    private ThirdPartyApiHelper thirdPartyApiHelper;

    public Object execute(HttpExecuteConfig config, Object requestParams, Map<String, Object> placeholderParams, Class returnType) {

        JSONObject requestContext = new JSONObject();
        requestContext.put("body",requestParams);
        requestContext.put("url",config.getUrl());

        if (!StringUtils.isEmpty(config.getRequestScript())) {
            try {

                requestContext = JSUtil.evalRequest(config.getRequestScript(), requestContext);
            } catch (Exception e) {
                log.error("数据json格式化异常",e);
                throw new RuntimeException("数据json格式化异常");
            }
        }
        String url = requestContext.getString("url");

        url = ExpressionUtil.resolveToStr(url, placeholderParams);
        Map<String, Object> headers = ExpressionUtil.resolveMap(config.getHeaders(), placeholderParams);

        JSONObject response = thirdPartyApiHelper.callHttp(url,config.getMethod(),headers,requestContext.get("body"));

        if (!StringUtils.isEmpty(config.getResponseScript())) {
            return JSUtil.evalResponse(config.getResponseScript(), JSONObject.toJSONString(response), returnType);
        }
        return response.toJavaObject(returnType);
    }
}
