/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.actuator;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.actuator.HttpExecuteConfig;
import com.digiwin.athena.http.asset.ThirdPartyApiHelper;
import com.digiwin.athena.utils.JSUtil;
import com.digiwin.athena.utils.expression.ExpressionUtil;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpActuator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpActuator.class);
    @Autowired
    private ThirdPartyApiHelper thirdPartyApiHelper;

    public Object execute(HttpExecuteConfig config, Object requestParams, Map<String, Object> placeholderParams, Class returnType) {
        JSONObject requestContext = new JSONObject();
        requestContext.put("body", requestParams);
        requestContext.put("url", (Object)config.getUrl());
        if (!StringUtils.isEmpty((CharSequence)config.getRequestScript())) {
            try {
                requestContext = JSUtil.evalRequest((String)config.getRequestScript(), (JSONObject)requestContext);
            }
            catch (Exception e) {
                log.error("\u6570\u636ejson\u683c\u5f0f\u5316\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException("\u6570\u636ejson\u683c\u5f0f\u5316\u5f02\u5e38");
            }
        }
        String url = requestContext.getString("url");
        url = ExpressionUtil.resolveToStr((String)url, placeholderParams);
        Map headers = ExpressionUtil.resolveMap(config.getHeaders(), placeholderParams, (String[])new String[0]);
        JSONObject response = this.thirdPartyApiHelper.callHttp(url, config.getMethod(), headers, requestContext.get((Object)"body"));
        if (!StringUtils.isEmpty((CharSequence)config.getResponseScript())) {
            return JSUtil.evalResponse((String)config.getResponseScript(), (String)JSONObject.toJSONString((Object)response), (Class)returnType);
        }
        return response.toJavaObject(returnType);
    }
}

