package com.digiwin.athena.dao;

import com.digiwin.athena.mongodb.domain.appCustomConfig.CustomControlRelation;
import com.digiwin.athena.mongodb.repository.MongoMultiVersionsRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Repository
public class CustomControlRelationV2MongoDao {

    @Autowired
    private MongoMultiVersionsRepositoryDecorator mongoMultiVersionsRepositoryDecorator;

    public void deleteByTargetCode(String targetCode) {
        Criteria criteria = Criteria.where("targetCode").is(targetCode);
        mongoMultiVersionsRepositoryDecorator.remove(new Query(criteria), CustomControlRelation.class);
    }

    public List<CustomControlRelation> queryByTargetCode(String targetCode) {
        Criteria criteria = Criteria.where("targetCode").is(targetCode);
        return mongoMultiVersionsRepositoryDecorator.find(new Query(criteria), CustomControlRelation.class);
    }

    public void insertAll(List<CustomControlRelation> customControlRelations) {
        mongoMultiVersionsRepositoryDecorator.insertAll(customControlRelations);
    }

    public CustomControlRelation save(CustomControlRelation customControlRelation) {
        return mongoMultiVersionsRepositoryDecorator.save(customControlRelation);
    }

    public List<String> selectExistAdpCodeByAdpApplication(String application) {
        Criteria criteria = Criteria.where("adpApplication").is(application);
        Query query = new Query(criteria);
        Field fields = query.fields();
        fields.include("sourceCode");
        return mongoMultiVersionsRepositoryDecorator.find(query,CustomControlRelation.class).stream().map(CustomControlRelation::getSourceCode).distinct().collect(Collectors.toList());
    }

    public List<CustomControlRelation> selectRelationByType(List<String> customControlTypeList){
        Criteria criteria = Criteria.where("customControlType").in(customControlTypeList);
        Query query = new Query(criteria);

        return mongoMultiVersionsRepositoryDecorator.find(query,CustomControlRelation.class);
    }

    public List<String> selectControlTypeBySourceCodeAndType(String sourceCode, Collection<String> needDeleteControlTypeList) {
        Criteria criteria = Criteria.where("customControlType").in(needDeleteControlTypeList).and("sourceCode").is(sourceCode);
        Query query = new Query(criteria);
        Field fields = query.fields();
        fields.include("customControlType");
        return mongoMultiVersionsRepositoryDecorator.find(query,CustomControlRelation.class).stream().map(CustomControlRelation::getCustomControlType).distinct().collect(Collectors.toList());
    }

    public List<CustomControlRelation> selectByCustomControlType(String customControlType) {
        Criteria criteria = Criteria.where("customControlType").is(customControlType);
        Query query = new Query(criteria);
        return mongoMultiVersionsRepositoryDecorator.find(query,CustomControlRelation.class);
    }

    public List<String> selectCustomControlTypeBySourceCode(String sourceCode) {
        Criteria criteria = Criteria.where("sourceCode").is(sourceCode);
        Query query = new Query(criteria);
        Field fields = query.fields();
        fields.include("customControlType");
        return mongoMultiVersionsRepositoryDecorator.find(query,CustomControlRelation.class).stream().map(CustomControlRelation::getCustomControlType).distinct().collect(Collectors.toList());
    }

    public void deleteByAdpApplication(String adpApplication) {
        Criteria criteria = Criteria.where("adpApplication").is(adpApplication);
        Query query = new Query(criteria);
        mongoMultiVersionsRepositoryDecorator.remove(query,CustomControlRelation.class);
    }

    public void deleteByTargetCodeAndAdpVersion(String targetCode, String adpVersion) {
        Criteria criteria = Criteria.where("targetCode").is(targetCode).and("adpVersion").is(adpVersion);
        mongoMultiVersionsRepositoryDecorator.remove(new Query(criteria), CustomControlRelation.class);
    }

    public List<CustomControlRelation> selectByTargetCodeAndApplication(String targetCode, String application) {
        Criteria criteria = Criteria.where("targetCode").is(targetCode).and("adpApplication").is(application);

        return mongoMultiVersionsRepositoryDecorator.find(new Query(criteria), CustomControlRelation.class);
    }

    public void deleteByObjectIds(List<String> objectIds) {
        Criteria criteria = Criteria.where("_id").in(objectIds);
        mongoMultiVersionsRepositoryDecorator.delete(new Query(criteria), CustomControlRelation.class);
    }

    public void remove(CustomControlRelation customControlRelation) {
        mongoMultiVersionsRepositoryDecorator.delete(customControlRelation);
    }

    public void removeMain(Query byId) {
        mongoMultiVersionsRepositoryDecorator.removeMain(byId,CustomControlRelation.class);
    }

    public List<CustomControlRelation> selectAppBySourceCodes(Collection<String> sourceCodes) {
        Criteria criteria = Criteria.where("sourceCode").in(sourceCodes);
        Query query = new Query(criteria);
        query.fields().include("sourceCode","name","adpApplication");
        return mongoMultiVersionsRepositoryDecorator.find(query,CustomControlRelation.class);
    }

    public void deleteByUiKeyAndTargetCode(String uiKey, String targetCode) {
        Criteria criteria = Criteria.where("uiKey").in(uiKey).and("targetCode").is(targetCode);
        mongoMultiVersionsRepositoryDecorator.delete(new Query(criteria),CustomControlRelation.class);
    }
}
