package com.digiwin.athena.mongodb.domain.appCustomConfig;


import com.digiwin.athena.utils.CurThreadInfoUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.Map;

@Document(collection = "customControlRelation")
public class CustomControlRelation {

    @Id
    private String objectId;

    private String adpTenantId;

    private String adpApplication;

    /**
     * 报表-Report,数据录入-DataEntry,项目-Project,任务-Task
     */
    private String targetType;

    private String dataViewQueryCode;

    /**
     * 界面key
     */
    private String uiKey;

    /**
     * 定制包code
     */
    private String sourceCode;
    /**
     * 控件类型
     */
    private String customControlType;

    /**
     * 作用的目标code
     */
    private String targetCode;

    private String name;

    private Map<String, ?> lang;

    private ExtFieldInfo extFieldInfo = new ExtFieldInfo();

    private String createBy;
    private Date createDate;
    private String editBy;
    private Date editDate;

    private String adpVersion;

    public String getAdpStatus() {
        return adpStatus;
    }

    public void setAdpStatus(String adpStatus) {
        this.adpStatus = adpStatus;
    }

    private String adpStatus = StringUtils.isNotEmpty(CurThreadInfoUtils.getAdpStatus()) ? CurThreadInfoUtils.getAdpStatus() : null;;

    public CustomControlRelation() {
    }

    public CustomControlRelation(String name, Map<String, ?> lang, String adpTenantId, String adpApplication, String targetCode) {
        this.name = name;
        this.lang=lang;
        this.adpTenantId = adpTenantId;
        this.adpApplication = adpApplication;
        this.targetCode = targetCode;
    }

    public CustomControlRelation(String name, Map<String, ?> lang, String adpTenantId, String adpApplication, String targetCode, String dataViewQueryCode, String uiKey) {
        this(name,lang,adpTenantId,adpApplication,targetCode);
        this.dataViewQueryCode = dataViewQueryCode;
        this.uiKey = uiKey;
    }

    public static class ExtFieldInfo{
        /**
         * 模型驱动下，作业保存额外字段信息
         */
        private String businessCode;

        private String category;

        private String nodeId;

        private String modelType;

        private String generateModelSource;

        public String getModelType() {
            return modelType;
        }

        public void setModelType(String modelType) {
            this.modelType = modelType;
        }

        public String getGenerateModelSource() {
            return generateModelSource;
        }

        public void setGenerateModelSource(String generateModelSource) {
            this.generateModelSource = generateModelSource;
        }

        public String getNodeId() {
            return nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getBusinessCode() {
            return businessCode;
        }

        public void setBusinessCode(String businessCode) {
            this.businessCode = businessCode;
        }

        public String getCategory() {
            return category;
        }

        public void setCategory(String category) {
            this.category = category;
        }
    }

    public String getAdpVersion() {
        return adpVersion;
    }

    public void setAdpVersion(String adpVersion) {
        this.adpVersion = adpVersion;
    }

    public String getDataViewQueryCode() {
        return dataViewQueryCode;
    }

    public void setDataViewQueryCode(String dataViewQueryCode) {
        this.dataViewQueryCode = dataViewQueryCode;
    }

    public ExtFieldInfo getExtFieldInfo() {
        return extFieldInfo;
    }

    public void setExtFieldInfo(ExtFieldInfo extFieldInfo) {
        this.extFieldInfo = extFieldInfo;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getEditBy() {
        return editBy;
    }

    public void setEditBy(String editBy) {
        this.editBy = editBy;
    }

    public Date getEditDate() {
        return editDate;
    }

    public void setEditDate(Date editDate) {
        this.editDate = editDate;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, ?> getLang() {
        return lang;
    }

    public void setLang(Map<String, ?> lang) {
        this.lang = lang;
    }

    public String getUiKey() {
        return uiKey;
    }

    public void setUiKey(String uiKey) {
        this.uiKey = uiKey;
    }

    public String getObjectId() {
        return objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getAdpTenantId() {
        return adpTenantId;
    }

    public void setAdpTenantId(String adpTenantId) {
        this.adpTenantId = adpTenantId;
    }

    public String getAdpApplication() {
        return adpApplication;
    }

    public void setAdpApplication(String adpApplication) {
        this.adpApplication = adpApplication;
    }

    public String getTargetType() {
        return targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getCustomControlType() {
        return customControlType;
    }

    public void setCustomControlType(String customControlType) {
        this.customControlType = customControlType;
    }

    public String getTargetCode() {
        return targetCode;
    }

    public void setTargetCode(String targetCode) {
        this.targetCode = targetCode;
    }
}
