/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao;

import com.digiwin.athena.domain.FileStore;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import jakarta.annotation.Resource;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class FileStoreMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileStoreMongoDao.class);
    @Resource
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    public void insert(FileStore fileStore) {
        this.mongoSystemRepositoryDecorator.insert((Object)fileStore);
    }

    public List<FileStore> selectByFileId(String fileId) {
        Criteria criteria = Criteria.where((String)"fileId").is((Object)fileId);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"order"}));
        return this.mongoSystemRepositoryDecorator.find(query, FileStore.class);
    }

    public void insertAll(List<FileStore> fileStores) {
        this.mongoSystemRepositoryDecorator.insertAll(fileStores);
    }

    public Long selectExistByMD5(String md5) {
        Criteria criteria = Criteria.where((String)"md5").is((Object)md5);
        return this.mongoSystemRepositoryDecorator.count(new Query((CriteriaDefinition)criteria), FileStore.class);
    }

    public FileStore selectFileBasicInfoByMD5(String md5) {
        Criteria criteria = Criteria.where((String)"md5").is((Object)md5);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().exclude("content");
        query.limit(1);
        return (FileStore)this.mongoSystemRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), FileStore.class);
    }
}

