/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.controller;

import com.digiwin.athena.domain.FileStore;
import com.digiwin.athena.dto.FxUploadFileAResDto;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.service.FileStoreService;
import com.digiwin.athena.service.MultiPlatformDiffInterface;
import com.digiwin.athena.utils.DownloadUtils;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotBlank;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/fileStore"})
public class FileStoreController {
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private MultiPlatformDiffInterface multiPlatformDiffInterface;

    @PostMapping(value={"/fxUploadFile"})
    public ResultDto<String> fxUploadFile(@RequestParam(value="attach") MultipartFile file, String tableNo, String documentNo) throws IOException {
        String res = this.fileStoreService.fxUploadFile(file, tableNo, documentNo);
        return ResultDto.createSuccess((Object)res);
    }

    @PostMapping(value={"/fxUploadFileA"})
    public ResultDto<FxUploadFileAResDto> fxUploadFileA(@RequestParam(value="file") MultipartFile file, @RequestHeader(value="program-code", defaultValue="lowcode") String programCode) throws IOException {
        FxUploadFileAResDto fxUploadFileAResDto = (FxUploadFileAResDto)this.multiPlatformDiffInterface.uploadFile(file, programCode);
        return ResultDto.createSuccess((Object)fxUploadFileAResDto);
    }

    @PostMapping(value={"/uploadFile"})
    public ResultDto<String> uploadFile(@RequestParam(value="file") MultipartFile file) throws IOException {
        String originalFilename = file.getOriginalFilename();
        int index = originalFilename.lastIndexOf(".");
        String name = originalFilename.substring(0, index);
        String type = originalFilename.substring(index + 1).toLowerCase();
        String fileId = this.fileStoreService.uploadFile(file.getInputStream(), name, type);
        return ResultDto.createSuccess((Object)fileId);
    }

    @GetMapping(value={"/download"})
    public void downloadFile(@NotBlank(message="fileId is empty") @NotBlank(message="fileId is empty") String fileId, HttpServletResponse response) throws IOException {
        this.download(response, fileId);
    }

    private void download(HttpServletResponse response, String fileId) throws IOException {
        FileStore file = this.fileStoreService.getFile(fileId);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getContent());
        ((InputStream)inputStream).reset();
        DownloadUtils.download((HttpServletResponse)response, (InputStream)inputStream, (String)(file.getFileName() + "." + file.getFileType()));
    }
}

