/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao;

import com.digiwin.athena.mongodb.domain.appCustomConfig.CustomControlRelation;
import com.digiwin.athena.mongodb.repository.MongoMultiVersionsRepositoryDecorator;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class CustomControlRelationV2MongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomControlRelationV2MongoDao.class);
    @Autowired
    private MongoMultiVersionsRepositoryDecorator mongoMultiVersionsRepositoryDecorator;

    public void deleteByTargetCode(String targetCode) {
        Criteria criteria = Criteria.where((String)"targetCode").is((Object)targetCode);
        this.mongoMultiVersionsRepositoryDecorator.remove(new Query((CriteriaDefinition)criteria), CustomControlRelation.class);
    }

    public List<CustomControlRelation> queryByTargetCode(String targetCode) {
        Criteria criteria = Criteria.where((String)"targetCode").is((Object)targetCode);
        return this.mongoMultiVersionsRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), CustomControlRelation.class);
    }

    public void insertAll(List<CustomControlRelation> customControlRelations) {
        this.mongoMultiVersionsRepositoryDecorator.insertAll(customControlRelations);
    }

    public CustomControlRelation save(CustomControlRelation customControlRelation) {
        return (CustomControlRelation)this.mongoMultiVersionsRepositoryDecorator.save((Object)customControlRelation);
    }

    public List<String> selectExistAdpCodeByAdpApplication(String application) {
        Criteria criteria = Criteria.where((String)"adpApplication").is((Object)application);
        Query query = new Query((CriteriaDefinition)criteria);
        Field fields = query.fields();
        fields.include("sourceCode");
        return this.mongoMultiVersionsRepositoryDecorator.find(query, CustomControlRelation.class).stream().map(CustomControlRelation::getSourceCode).distinct().collect(Collectors.toList());
    }

    public List<CustomControlRelation> selectRelationByType(List<String> customControlTypeList) {
        Criteria criteria = Criteria.where((String)"customControlType").in(customControlTypeList);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoMultiVersionsRepositoryDecorator.find(query, CustomControlRelation.class);
    }

    public List<String> selectControlTypeBySourceCodeAndType(String sourceCode, Collection<String> needDeleteControlTypeList) {
        Criteria criteria = Criteria.where((String)"customControlType").in(needDeleteControlTypeList).and("sourceCode").is((Object)sourceCode);
        Query query = new Query((CriteriaDefinition)criteria);
        Field fields = query.fields();
        fields.include("customControlType");
        return this.mongoMultiVersionsRepositoryDecorator.find(query, CustomControlRelation.class).stream().map(CustomControlRelation::getCustomControlType).distinct().collect(Collectors.toList());
    }

    public List<CustomControlRelation> selectByCustomControlType(String customControlType) {
        Criteria criteria = Criteria.where((String)"customControlType").is((Object)customControlType);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoMultiVersionsRepositoryDecorator.find(query, CustomControlRelation.class);
    }

    public List<String> selectCustomControlTypeBySourceCode(String sourceCode) {
        Criteria criteria = Criteria.where((String)"sourceCode").is((Object)sourceCode);
        Query query = new Query((CriteriaDefinition)criteria);
        Field fields = query.fields();
        fields.include("customControlType");
        return this.mongoMultiVersionsRepositoryDecorator.find(query, CustomControlRelation.class).stream().map(CustomControlRelation::getCustomControlType).distinct().collect(Collectors.toList());
    }

    public void deleteByAdpApplication(String adpApplication) {
        Criteria criteria = Criteria.where((String)"adpApplication").is((Object)adpApplication);
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoMultiVersionsRepositoryDecorator.remove(query, CustomControlRelation.class);
    }

    public void deleteByTargetCodeAndAdpVersion(String targetCode, String adpVersion) {
        Criteria criteria = Criteria.where((String)"targetCode").is((Object)targetCode).and("adpVersion").is((Object)adpVersion);
        this.mongoMultiVersionsRepositoryDecorator.remove(new Query((CriteriaDefinition)criteria), CustomControlRelation.class);
    }

    public List<CustomControlRelation> selectByTargetCodeAndApplication(String targetCode, String application) {
        Criteria criteria = Criteria.where((String)"targetCode").is((Object)targetCode).and("adpApplication").is((Object)application);
        return this.mongoMultiVersionsRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), CustomControlRelation.class);
    }

    public void deleteByObjectIds(List<String> objectIds) {
        Criteria criteria = Criteria.where((String)"_id").in(objectIds);
        this.mongoMultiVersionsRepositoryDecorator.delete(new Query((CriteriaDefinition)criteria), CustomControlRelation.class);
    }

    public void remove(CustomControlRelation customControlRelation) {
        this.mongoMultiVersionsRepositoryDecorator.delete((Object)customControlRelation);
    }

    public void removeMain(Query byId) {
        this.mongoMultiVersionsRepositoryDecorator.removeMain(byId, CustomControlRelation.class);
    }

    public List<CustomControlRelation> selectAppBySourceCodes(Collection<String> sourceCodes) {
        Criteria criteria = Criteria.where((String)"sourceCode").in(sourceCodes);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include(new String[]{"sourceCode", "name", "adpApplication"});
        return this.mongoMultiVersionsRepositoryDecorator.find(query, CustomControlRelation.class);
    }

    public void deleteByUiKeyAndTargetCode(String uiKey, String targetCode) {
        Criteria criteria = Criteria.where((String)"uiKey").in(new Object[]{uiKey}).and("targetCode").is((Object)targetCode);
        this.mongoMultiVersionsRepositoryDecorator.delete(new Query((CriteriaDefinition)criteria), CustomControlRelation.class);
    }
}

