/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.FxUploadFileAResDto;
import com.digiwin.athena.dto.SystemParam;
import com.digiwin.athena.dto.UploadFileV3ResDto;
import com.digiwin.athena.dto.UploadedFileInfoV3ResDto;
import com.digiwin.athena.http.distribution.FxApiHelper;
import com.digiwin.athena.http.distribution.FxUploadFileV3ResDto;
import com.digiwin.athena.http.distribution.ProgramAuthResDto;
import com.digiwin.athena.http.distribution.UploadFileV3ReqDto;
import com.digiwin.athena.service.FileStoreService;
import com.digiwin.athena.service.MultiPlatformDiffInterface;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@ConditionalOnProperty(name={"system_env"}, havingValue="FenXiao")
public class MultiPlatformDiffImpl
implements MultiPlatformDiffInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiPlatformDiffImpl.class);
    @Autowired
    private FxApiHelper fxApiHelper;
    @Autowired
    private FileStoreService fileStoreService;

    public JSONObject getSysEnum() {
        JSONObject sysEnum = this.fxApiHelper.getSysEnum();
        return sysEnum;
    }

    public List<SystemParam> getSysEnumV2() {
        return null;
    }

    public ProgramAuthResDto getProgramAuth(String code) {
        return this.fxApiHelper.getProgramAuth(code);
    }

    public UploadFileV3ResDto uploadFileV3(MultipartFile file, String componentId, String programId) {
        UploadFileV3ReqDto uploadFileV3ReqDto = new UploadFileV3ReqDto();
        uploadFileV3ReqDto.setFileName(file.getOriginalFilename());
        uploadFileV3ReqDto.setComponentId(componentId);
        uploadFileV3ReqDto.setProgramId(programId);
        FxUploadFileV3ResDto fxUploadFileV3ResDto = this.fxApiHelper.uploadFileV3(uploadFileV3ReqDto);
        UploadFileV3ResDto res = new UploadFileV3ResDto();
        res.setFileId(fxUploadFileV3ResDto.getId());
        res.setFileName(fxUploadFileV3ResDto.getFileName());
        res.setFileType(fxUploadFileV3ResDto.getFileType());
        res.setUrl(fxUploadFileV3ResDto.getUrl());
        return res;
    }

    public FxUploadFileAResDto uploadFile(MultipartFile file, String programCode) throws IOException {
        FxUploadFileAResDto fxUploadFileAResDto = this.fileStoreService.fxUploadFileA(file, programCode);
        return fxUploadFileAResDto;
    }

    public <T> T queryUploadedFileInfo(List<String> fileIds) {
        List fxUploadedFIleInfoV3ResDtos = this.fxApiHelper.queryFileInfoByUUID(fileIds);
        List res = fxUploadedFIleInfoV3ResDtos.stream().map(c -> {
            UploadedFileInfoV3ResDto uploadedFileInfoV3ResDto = new UploadedFileInfoV3ResDto();
            uploadedFileInfoV3ResDto.setFileUrl(c.getFileUrl());
            uploadedFileInfoV3ResDto.setFileName(c.getFileName());
            uploadedFileInfoV3ResDto.setFileId(c.getFileId());
            return uploadedFileInfoV3ResDto;
        }).collect(Collectors.toList());
        return (T)res;
    }
}

