package com.digiwin.athena.controller;

import com.digiwin.athena.base.BaseConstant;
import com.digiwin.athena.domain.FileStore;
import com.digiwin.athena.dto.FxUploadFileAResDto;
import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.dto.UploadFileV3ResDto;
import com.digiwin.athena.dto.UploadedFileInfoV3ResDto;
import com.digiwin.athena.service.FileStoreService;
import com.digiwin.athena.service.MultiPlatformDiffInterface;
import com.digiwin.athena.utils.DownloadUtils;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

@RestController
@RequestMapping("/fileStore")
public class FileStoreController {

    @Autowired
    private FileStoreService fileStoreService;

    @Autowired
    private MultiPlatformDiffInterface multiPlatformDiffInterface;

    @PostMapping("/fxUploadFile")
    public ResultDto<String> fxUploadFile(@RequestParam("attach") MultipartFile file, String tableNo, String documentNo) throws IOException {
        String res = fileStoreService.fxUploadFile(file, tableNo, documentNo);
        return ResultDto.createSuccess(res);
    }

    @PostMapping("/fxUploadFileA")
    public ResultDto<FxUploadFileAResDto> fxUploadFileA(@RequestParam("file") MultipartFile file,
                                                        @RequestHeader(value = "program-code",defaultValue = "lowcode")String programCode) throws IOException {
        FxUploadFileAResDto fxUploadFileAResDto = multiPlatformDiffInterface.uploadFile(file, programCode);
        return ResultDto.createSuccess(fxUploadFileAResDto);
    }

    @PostMapping("/uploadFileV3")
    public ResultDto<UploadFileV3ResDto> uploadFileV3(@RequestParam("file") MultipartFile file,
                                                         String componentId,
                                                         String programId) throws IOException {
        UploadFileV3ResDto res = multiPlatformDiffInterface.uploadFileV3(file, componentId,programId);
        return ResultDto.createSuccess(res);
    }

    @PostMapping("/queryUploadedFileInfo")
    public ResultDto<List<UploadedFileInfoV3ResDto>> queryUploadedFileInfo(@RequestBody List<String> fileIds){
        List<UploadedFileInfoV3ResDto> res = multiPlatformDiffInterface.queryUploadedFileInfo(fileIds);
        return ResultDto.createSuccess(res);
    }

    @PostMapping("/uploadFile")
    public ResultDto<String> uploadFile(@RequestParam("file") MultipartFile file) throws IOException {
        String originalFilename = file.getOriginalFilename();
        int index = originalFilename.lastIndexOf(BaseConstant.DOT);
        String name = originalFilename.substring(0, index);
        String type = originalFilename.substring(index + 1).toLowerCase();
        String fileId = fileStoreService.uploadFile(file.getInputStream(), name, type);
        return ResultDto.createSuccess(fileId);
    }

    @GetMapping("/download")
    public void downloadFile(@NotBlank(message = "fileId is empty")String fileId, HttpServletResponse response) throws IOException {
        download(response, fileId);
    }

    private void download(HttpServletResponse response, String fileId) throws IOException {
        FileStore file = fileStoreService.getFile(fileId);
        InputStream inputStream = new ByteArrayInputStream(file.getContent());
        inputStream.reset();
        DownloadUtils.download(response, inputStream, file.getFileName() + "." + file.getFileType());
    }
}
