package com.digiwin.athena.dao;

import com.digiwin.athena.domain.AppBranchPO;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Slf4j
@Repository
public class AppBranchMongoDao {

    @Resource
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    public void insert(AppBranchPO entity) {
        mongoSystemRepositoryDecorator.insert(entity);
    }

    public void update(AppBranchPO entity) {
        mongoSystemRepositoryDecorator.save(entity);
    }

    public AppBranchPO selectOneByCondition(Criteria criteria) {
        Query query = new Query(criteria);
        return mongoSystemRepositoryDecorator.findOne(query, AppBranchPO.class);
    }

    public List<AppBranchPO> selectListByCondition(Criteria criteria) {
        Query query = new Query(criteria);
        return mongoSystemRepositoryDecorator.find(query, AppBranchPO.class);
    }

    public void deleteListByCondition(Criteria criteria) {
        Query query = new Query(criteria);
        mongoSystemRepositoryDecorator.delete(query, AppBranchPO.class);
    }

}
