package com.digiwin.athena.dao;

import com.digiwin.athena.domain.ApplicationBakPO;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Slf4j
@Repository
public class ApplicationBakMongoDao {

    @Resource
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    public void insert(ApplicationBakPO entity) {
        mongoSystemRepositoryDecorator.insert(entity);
    }

    public void update(ApplicationBakPO entity) {
        mongoSystemRepositoryDecorator.save(entity);
    }

    public ApplicationBakPO selectOneByCondition(Criteria criteria) {
        Query query = new Query(criteria);
        return mongoSystemRepositoryDecorator.findOne(query, ApplicationBakPO.class);
    }

    public List<ApplicationBakPO> selectListByCondition(Criteria criteria) {
        Query query = new Query(criteria);
        return mongoSystemRepositoryDecorator.find(query, ApplicationBakPO.class);
    }

    public void deleteListByCondition(Criteria criteria) {
        Query query = new Query(criteria);
        mongoSystemRepositoryDecorator.delete(query, ApplicationBakPO.class);
    }

}
