package com.digiwin.athena.dao;

import com.digiwin.athena.domain.FileStore;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Slf4j
@Repository
public class FileStoreMongoDao {
    @Resource
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    public void insert(FileStore fileStore){
        mongoSystemRepositoryDecorator.insert(fileStore);
    }

    public List<FileStore> selectByFileId(String fileId){
        Criteria criteria = Criteria.where("fileId").is(fileId);
        Query query = new Query(criteria);
        query.with(Sort.by(Sort.Direction.ASC,"order"));
        return mongoSystemRepositoryDecorator.find(query,FileStore.class);
    }

    public void insertAll(List<FileStore> fileStores) {
        mongoSystemRepositoryDecorator.insertAll(fileStores);
    }

    public Long selectExistByMD5(String md5) {

        Criteria criteria = Criteria.where("md5").is(md5);
        return mongoSystemRepositoryDecorator.count(new Query(criteria), FileStore.class);
    }

    public FileStore selectFileBasicInfoByMD5(String md5) {
        Criteria criteria = Criteria.where("md5").is(md5);
        Query query = new Query(criteria);
        query.fields().exclude("content");
        query.limit(1);
        return mongoSystemRepositoryDecorator.findOne(new Query(criteria),FileStore.class);
    }

}
