package com.digiwin.athena.dao;

import com.digiwin.athena.mongodb.domain.other.PresetData;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Slf4j
@Repository
public class PresetDataV2MongoDao {
    @Autowired
    MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    public PresetData selectOneByKey(String key) {
        Criteria criteria = Criteria.where("key").is(key);
        Query query = new Query(criteria);
        List<PresetData> presetDataList = mongoSystemRepositoryDecorator.find(query, PresetData.class);
        return presetDataList.isEmpty() ? null : presetDataList.get(0);
    }

    public List<PresetData> selectByKeys(List<String> keys){
        Query query = new Query(Criteria.where("key").in(keys));
        return mongoSystemRepositoryDecorator.find(query,PresetData.class);
    }

    public void insert(PresetData presetData) {
        mongoSystemRepositoryDecorator.insert(presetData);
    }

    public void save(PresetData presetData) {
        mongoSystemRepositoryDecorator.save(presetData);
    }

    public void removeByKeys(List<String> keys) {
        Query query = new Query(Criteria.where("key").in(keys));
        mongoSystemRepositoryDecorator.remove(query, PresetData.class);
    }
}
