package com.digiwin.athena.dao;

import com.digiwin.athena.mongodb.domain.appCustomConfig.ApplicationCustomConfig;
import com.digiwin.athena.mongodb.domain.appCustomConfig.CustomControlRelation;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Repository
public class RCustomControlRelationMongoDao {

    @Autowired
    private MongoRuntimeRepositoryDecorator mongoRuntimeRepositoryDecorator;

    public void deleteByTargetCodeAndApp(String targetCode, String adpApplication) {
        Criteria criteria = Criteria.where("targetCode").is(targetCode).and("adpApplication").is(adpApplication);
        mongoRuntimeRepositoryDecorator.delete(new Query(criteria), CustomControlRelation.class);
    }

    public void insertAll(List<CustomControlRelation> controlRelations) {
        mongoRuntimeRepositoryDecorator.insertAll(controlRelations);
    }

    public void deleteByTargetCodesAndApp(Collection<String> targetCodes, String adpApplication) {
        Criteria criteria = Criteria.where("targetCode").in(targetCodes).and("adpApplication").is(adpApplication);
        mongoRuntimeRepositoryDecorator.delete(new Query(criteria), CustomControlRelation.class);
    }

    public void insert(ApplicationCustomConfig applicationCustomConfig) {
        mongoRuntimeRepositoryDecorator.insert(applicationCustomConfig);
    }

    public void deleteByAdpCodesAndApp(List<String> adpCodes, String adpApplication) {
        Criteria criteria = Criteria.where("adpCode").in(adpCodes).and("adpApplication").is(adpApplication);
        mongoRuntimeRepositoryDecorator.delete(new Query(criteria), CustomControlRelation.class);
    }

    public List<String> selectSourceCodeByTargetCode(String targetCode) {
        Criteria criteria = Criteria.where("targetCode").in(targetCode);
        Query query = new Query(criteria);
        query.fields().include("sourceCode");
        return  mongoRuntimeRepositoryDecorator.find(query, CustomControlRelation.class).stream().map(CustomControlRelation::getSourceCode).collect(Collectors.toList());
    }

    public void deleteByApplication(String appCode) {
        Criteria criteria = Criteria.where("adpApplication").is(appCode);
        mongoRuntimeRepositoryDecorator.delete(new Query(criteria), CustomControlRelation.class);
    }
}
