package com.digiwin.athena.dao;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.domain.UserDefinedCenter;
import com.digiwin.athena.mongodb.repository.MongoRuntimeRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;
import java.util.Set;

@Slf4j
@Repository
public class UserDefinedCenterMongoDao {

    @Autowired
    private MongoRuntimeRepositoryDecorator mongoRuntimeRepositoryDecorator;

    public void insert(UserDefinedCenter userDefinedCenter){
        mongoRuntimeRepositoryDecorator.insert(userDefinedCenter);
    }

    public UserDefinedCenter selectByUserIdAndTenantId(String userId, String tenantId, Criteria extraCriteria){
        Criteria criteria = Criteria.where("userId").is(userId).and("tenantId").is(tenantId);
        if (extraCriteria!=null){
            criteria.andOperator(extraCriteria);
        }

        UserDefinedCenter res = mongoRuntimeRepositoryDecorator.findOne(new Query(criteria), UserDefinedCenter.class);
        return res;
    }

    public void save(UserDefinedCenter userDefinedCenter){
        mongoRuntimeRepositoryDecorator.save(userDefinedCenter);
    }


    public List<UserDefinedCenter> selectAllByUserIdAndTenantId(String userId, String tenantId, Criteria extraCriteria){
        Criteria criteria = Criteria.where("userId").is(userId).and("tenantId").is(tenantId);
        if (extraCriteria!=null){
            criteria.andOperator(extraCriteria);
        }

        List<UserDefinedCenter> res = mongoRuntimeRepositoryDecorator.find(new Query(criteria), UserDefinedCenter.class);
        return res;
    }

    public void delete(UserDefinedCenter userDefinedCenter) {
        mongoRuntimeRepositoryDecorator.delete(userDefinedCenter);
    }

    public void deleteByBizCode(Collection<String> bizCodes) {
        mongoRuntimeRepositoryDecorator.delete(new Query(Criteria.where("bizCode").in(bizCodes)),UserDefinedCenter.class);
    }
}
