package com.digiwin.athena.dao;

import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import com.digiwin.athena.mysql.domain.user.UserPO;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Slf4j
@Repository
public class UserPoMongoDao {

    @Resource
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    public UserPO selectOne(String name){
        Criteria criteria = Criteria.where("name").is(name);
        return mongoSystemRepositoryDecorator.findOne(new Query(criteria),UserPO.class);
    }

    public void save(UserPO userPO) {
        mongoSystemRepositoryDecorator.save(userPO);
    }

    public void insert(UserPO userPOSave) {
        mongoSystemRepositoryDecorator.insert(userPOSave);
    }

    public Collection<String> selectExistNameByNames(Collection<String> names) {
        Criteria criteria = Criteria.where("name").in(names);
        return mongoSystemRepositoryDecorator.find(new Query(criteria),UserPO.class).stream().map(UserPO::getName).collect(Collectors.toSet());
    }

    public void insertAll(List<UserPO> userPOS) {
        mongoSystemRepositoryDecorator.insertAll(userPOS);
    }
}
