package com.digiwin.athena.service.impl;

import com.digiwin.athena.backendmanage.domain.ManageBackgroundUser;
import com.digiwin.athena.dao.ManageBackgroundUserMongoDao;
import com.digiwin.athena.mysql.domain.user.UserPO;
import com.digiwin.athena.service.ManageBackgroundUserService;
import com.digiwin.athena.utils.user.UserHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
@Slf4j
public class ManageBackgroundUserServiceImpl implements ManageBackgroundUserService {

    @Autowired
    private ManageBackgroundUserMongoDao manageBackgroundUserMongoDao;
    @Override
    public Boolean isManager() {
        UserPO user = UserHelper.getCurrentUser();
        List<ManageBackgroundUser> manageBackgroundUserList = manageBackgroundUserMongoDao.findAll();
        List<String> nameList = manageBackgroundUserList.stream().map(ManageBackgroundUser::getName).collect(Collectors.toList());
        if (nameList.contains(user.getName())){
            return true;
        }
        return false;
    }
}
