package com.digiwin.athena.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.mongodb.domain.other.PresetData;
import com.digiwin.athena.service.RuntimeDataQuery;
import com.digiwin.athena.sys.PresetDataServiceV2;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("systemDatasourceRuntimeData")
@Slf4j
public class SystemDatasourceRuntimeDataQuery implements RuntimeDataQuery<List<JSONObject>> {

    @Autowired
    private PresetDataServiceV2 presetDataServiceV2;

    @Override
    public List<JSONObject> queryRuntimeData(JSONObject param) {

        PresetData presetDataObject = presetDataServiceV2.getPresetDataObject("system_datasource");
        List<String> dataList = (List<String>) presetDataObject.getObj();
        List<JSONObject> res = new ArrayList<>();
        for (String data : dataList) {
            res.add(JSONObject.parseObject(data));
        }
        return res;
    }
}
