package com.digiwin.athena.service.tenant.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.config.ModuleConfig;
import com.digiwin.athena.constant.Constant;
import com.digiwin.athena.constant.IamConstant;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.http.distribution.FxUser;
import com.digiwin.athena.service.tenant.TenantService;
import com.digiwin.athena.utils.JwtUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author liyuetao
 * @title: TenantServiceImpl
 * @projectName athena_designer
 * @description: TODO
 * @date 2022/9/2717:31
 */
@Service
@Slf4j
public class TenantServiceImpl implements TenantService {

    @Autowired
    private ModuleConfig moduleConfig;
    @Value("${rest-url.appToken}")
    private String appToken;

/*    @Override
    public List<IamTenantCustomInfo> queryCustomerTenants(String token) {
        // 正式区查询测试区的同客代租户，同单模块发布
        String tenantId = getTenantByToken(token);
        List<IamTenantCustomInfo> res= deployServiceApiHelper.queryCustomerTenants(tenantId);
        if (!res.isEmpty()) {
            return res;
        } else {
            JSONObject tenantInfoByToken = getTenantInfoByToken(token);
            // 返回失败的话，直接覆盖data，用用户本身的租户
            IamTenantCustomInfo iamTenantCustomInfo = new IamTenantCustomInfo();
            iamTenantCustomInfo.setId(tenantInfoByToken.getString("tenantId"));
            iamTenantCustomInfo.setSid(tenantInfoByToken.getLong("tenantSid"));
            iamTenantCustomInfo.setName(tenantInfoByToken.getString("tenantName"));

            return Arrays.asList(iamTenantCustomInfo);
        }
    }*/

    @Override
    public List<JSONObject> queryUserTenants(String token) {
        ModuleConfig.Module lcdp = moduleConfig.getLcdp();
        String iamDomain = moduleConfig.getIam().getDomain();
        String queryUserTenantsUrl = IamConstant.queryUserTenants;
        queryUserTenantsUrl = StrUtil.format(queryUserTenantsUrl, lcdp.getAppId());
        String response = HttpUtil.createPost(iamDomain + queryUserTenantsUrl)
                .header("digi-middleware-auth-user", token)
                .header(Constant.APP_TOKEN, appToken)
                .execute().body();
        try {
            return JSON.parseArray(response).toJavaList(JSONObject.class);
        } catch (Exception e) {
            JSONObject responseObj = JSON.parseObject(response);
            log.error("查询租户失败:{}", response);
            throw new BusinessException(3008, new Object[]{responseObj.getString("errorMessage")});
        }
    }

    @Override
    public String getTenantByToken(String token) {
        /*String response = analyzeIamToken(token);
        JSONObject responseObj = JSON.parseObject(response);
        String tenantId = responseObj.getString("tenantId");
        if (StringUtils.isEmpty(tenantId)) {
            log.error("解析token失败:", response);
            throw new BusinessException(responseObj.getString("errorMessage"));
        }*/
        Jws<Claims> claimsJws = JwtUtil.parseToken(token);
        FxUser fxUser = FxUser.create(claimsJws);
        return fxUser.getC_ent().toString();
    }

    @Override
    public JSONObject getTenantInfoByToken(String token) {
        TenantInfo tenantInfo = JwtUtil.getTenantInfo(token);
        return JSONObject.parseObject(JSONObject.toJSONString(tenantInfo));
        /*String response = analyzeIamToken(token);
        JSONObject responseObj = JSON.parseObject(response);
        String tenantId = responseObj.getString("tenantId");
        if (StringUtils.isEmpty(tenantId)) {
            log.error("解析token失败:", response);
            throw new BusinessException(responseObj.getString("errorMessage"));
        }
        return responseObj;*/
    }


    @Override
    public String analyzeIamToken(String token) {
        String iamDomain = moduleConfig.getIam().getDomain();
        String tokenParseUrl = IamConstant.tokenParseUrl;
        String response = HttpUtil.createPost(iamDomain + tokenParseUrl)
                .header("digi-middleware-auth-user", token)
                .header(Constant.APP_TOKEN, appToken)
                .execute().body();
        return response;
    }
}
