/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.tenant.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.config.ModuleConfig;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.http.distribution.FxUser;
import com.digiwin.athena.service.tenant.TenantService;
import com.digiwin.athena.utils.JwtUtil;
import io.jsonwebtoken.Jws;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TenantServiceImpl
implements TenantService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantServiceImpl.class);
    @Autowired
    private ModuleConfig moduleConfig;
    @Value(value="${rest-url.appToken}")
    private String appToken;

    @Override
    public List<JSONObject> queryUserTenants(String token) {
        ModuleConfig.Module lcdp = this.moduleConfig.getLcdp();
        String iamDomain = this.moduleConfig.getIam().getDomain();
        String queryUserTenantsUrl = "/api/iam/v2/tenant?appId={}";
        queryUserTenantsUrl = StrUtil.format((CharSequence)queryUserTenantsUrl, (Object[])new Object[]{lcdp.getAppId()});
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)(iamDomain + queryUserTenantsUrl)).header("digi-middleware-auth-user", token)).header("digi-middleware-auth-app", this.appToken)).execute().body();
        try {
            return JSON.parseArray((String)response).toJavaList(JSONObject.class);
        }
        catch (Exception e) {
            JSONObject responseObj = JSON.parseObject((String)response);
            log.error("\u67e5\u8be2\u79df\u6237\u5931\u8d25:{}", (Object)response);
            throw new BusinessException(Integer.valueOf(3008), new Object[]{responseObj.getString("errorMessage")});
        }
    }

    @Override
    public String getTenantByToken(String token) {
        Jws claimsJws = JwtUtil.parseToken((String)token);
        FxUser fxUser = FxUser.create((Jws)claimsJws);
        return fxUser.getC_ent().toString();
    }

    @Override
    public JSONObject getTenantInfoByToken(String token) {
        TenantInfo tenantInfo = JwtUtil.getTenantInfo((String)token);
        return JSONObject.parseObject((String)JSONObject.toJSONString((Object)tenantInfo));
    }

    @Override
    public String analyzeIamToken(String token) {
        String iamDomain = this.moduleConfig.getIam().getDomain();
        String tokenParseUrl = "/api/iam/v2/identity/token/analyze";
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)(iamDomain + tokenParseUrl)).header("digi-middleware-auth-user", token)).header("digi-middleware-auth-app", this.appToken)).execute().body();
        return response;
    }
}

