package com.digiwin.athena.mysql.domain.user;

import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.time.LocalDateTime;

@Data
@Document(collection = "user")
public class UserPO {
    @Id
    private String id;
    private Long gitId;
    /*
     * 20241225 上正式区 备注
     * 对应iam那边的用户sid，测试区copy库到正式区user表后 没有刷这个字段，后续要使用用户的sid时需要刷这里的数据，顺便一起刷mongo中sys_tenantCreatorInfo表的tenantCreatorSid字段，也是用户的sid
     */
    private Long iamId;
    private String name;
    private String nickName;
    private String accessToken;
    private String refreshToken;
    /**
     * 0:游客 1:注册未授权 2:git授权
     */
    private Integer state;
    private LocalDateTime createTime;
    private LocalDateTime modifyTime;
    private String currentBranch;

    private String photo;

}
