package com.digiwin.athena.utils;

import cn.hutool.extra.spring.SpringUtil;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.service.UserInfoInterface;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import jakarta.xml.bind.DatatypeConverter;

import javax.crypto.spec.SecretKeySpec;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import io.jsonwebtoken.JwtBuilder;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil implements ApplicationContextAware {
    private static UserInfoInterface userInfoInterface;
    private static  String PRIVATE_KEY = "1IRAzkp2rS9bbNEbQQCkMGeNG53hxq2NnsIrnsc1RKZxd4jLEGEnh6QExwH6at2o";
//    private static  String PRIVATE_KEY = "%^*(LongAndHardToGuessValueWithSpecialCharacters@%&$";
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.HS512;
    private static  byte[] API_BYTES_KEY = DatatypeConverter.parseBase64Binary(PRIVATE_KEY);
    private static Key SIGNING_KEY = new SecretKeySpec(API_BYTES_KEY, SIGNATURE_ALGORITHM.getJcaName());


    public static Jws<Claims> parseToken(String token){
        Key fxJwtKey = SpringUtil.getBean("fxJwtKey", Key.class);
        return Jwts.parser()
                .setSigningKey(fxJwtKey)
                .parseClaimsJws(token);
    }

    public static TenantInfo getTenantInfo(String userToken) {

        return userInfoInterface.parseTokenGetTenantInfo(userToken);
    }

    public static String getTenantTeamId(String token){
        TenantInfo tenantInfo = getTenantInfo(token);
        return tenantInfo.getTeamId();
    }

    /**
     * 生成JWT Token
     * @param claims 载荷内容（可为null）
     * @param subject 主题（可为null）
     * @param expiration 过期时间（可为null，单位毫秒）
     * @return JWT字符串
     */
    public static String generateToken(Map<String, Object> claims, String subject, Date expiration) {
        JwtBuilder builder = Jwts.builder()
                .signWith(SIGNATURE_ALGORITHM, SIGNING_KEY);

        if (claims != null) {
            builder.setClaims(claims);
        }
        if (subject != null) {
            builder.setSubject(subject);
        }
        if (expiration != null) {
            builder.setExpiration(expiration);
        }
        builder.setIssuedAt(new Date());

        return builder.compact();
    }

    public static String generateToken(String subject) {
        return generateToken(null, subject, null);
    }

    public static void main(String[] args) {
//        Jws<Claims> claimsJws =Jwts.parser()
//                .setSigningKey(SIGNING_KEY)
//                .parseClaimsJws("eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJ7XCJwcm9maWxlXCI6e1wiYWJqdHlwZVwiOlwiMDAxXCIsXCJjX29ialwiOlwiYWRtaW5cIixcImlzRmlyc3RMb2dpblwiOlwiWVwiLFwicHJpbWVyS2V5XCI6XCJqaWFuZ214XCIsXCJjX3VzZXJcIjpcImppYW5nbXhcIixcImNfY2hubFwiOlwiXCIsXCJjX3Blcl9uMVwiOlwi57O757uf566h55CG5ZGYXCIsXCJkYWVjdXJyXCI6XCJDTllcIixcImdyb3VwTGlzdFwiOltdLFwiY19jaG5sX24xXCI6XCJcIixcImNfZW50XCI6OTgsXCJjX29ianR5cGVcIjpcIjFcIixcImNfc3RvcmVcIjpcIlwiLFwiY19sYW5jX24xXCI6XCLnroDkvZPkuK3mlodcIixcImNfY3VzdFwiOlwiXCIsXCJlZmZfdGltZVwiOlwiLTFcIixcImNfbGFuZ1wiOlwiemhfQ05cIixcImNfY3VyclwiOlwiQ05ZXCIsXCJjX29yZ1wiOlwiMTAwMDAxXCIsXCJhYmptdGVsXCI6XCIxODI2NjY2NjY2NlwiLFwiY19kZXB0XCI6XCIxMDAwMDFcIixcImNfdXNlcl9uMVwiOlwi6JKL5piO5pifXCIsXCJjX3BlclwiOlwiYWRtaW5cIixcImNfb3JnX24xXCI6XCLpvI7mjbfova_ku7ZcIn19IiwiZXhwIjoxNzUyNjU5NjM3LCJpYXQiOjE3NTI1NzMyMzcsImp0aSI6IjVkMTJlZTgzLTllM2ItNGJjNC04NTk5LWZmNTE4ZWUzMWQxOSJ9.7K08DmPz-yP57DmzNTsP5BzdjOpiKTk_KFJxlf3D8KoEl1GAPN-bVfaBH976KIIollOLYPY6GZvz8jw37fURZQ");
//        System.out.println(claimsJws.getSignature());
//        System.out.println(claimsJws.getBody().getExpiration());
//        System.out.println(claimsJws.getBody().getSubject());
        Map<String, Object> map = new HashMap<>();
        map.put("c_user", "jiangmq");
        map.put("c_user_n1", "蒋明强");
        map.put("c_ent", "99");
        map.put("c_org_n1", "开发平台测试租户");
        String subject = "{\"profile\":{\"pwd_ttl_expire\":\"N\",\"abjtype\":\"001\",\"c_obj\":\"admin\",\"isFirstLogin\":\"N\",\"primerKey\":\"jiangmq\",\"c_user\":\"jiangmq\",\"c_per_n1\":\"系统管理员\",\"daecurr\":\"CNY\",\"groupList\":[{\"name\":\"办公\",\"icon\":\"anticon-solution\",\"aaa003\":1,\"id\":\"01\"},{\"name\":\"客户管理\",\"icon\":\"anticon-team\",\"aaa003\":2,\"id\":\"02\"},{\"name\":\"客户分析\",\"aaa003\":3,\"id\":\"03\"}],\"c_dept_n1\":\"销售一部\",\"c_ent\":99,\"c_objtype\":\"1\",\"c_lanc_n1\":\"简体中文\",\"eff_time\":\"24\",\"c_lang\":\"zh_CN\",\"c_org\":\"100001\",\"c_curr\":\"CNY\",\"c_dept\":\"100001\",\"c_user_n1\":\"蒋明强\",\"c_per\":\"admin\",\"pwd_ttl_expire_rule\":\"0\",\"c_org_n1\":\"鼎捷数智\"}}\n";
        String s = JwtUtil.generateToken(map, subject, new Date(System.currentTimeMillis() + 1000 * 60 * 60 * 24 * 7));
        System.out.println(s);

        Jws<Claims> claimsJws = JwtUtil.parseToken(s);
        System.out.println(claimsJws.getBody().getSubject());
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        JwtUtil.userInfoInterface= applicationContext.getBean(UserInfoInterface.class);
    }
}
