/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.interceptor;

import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.service.UserInfoInterface;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class CurUserThreadInterceptor
implements HandlerInterceptor {
    public static final Set<String> INDIVIDUAL_CASE_WHITE_URLS = new HashSet<String>();
    public static final List<Pattern> INDIVIDUAL_CASE_WHITE_PATTERN_URLS = new ArrayList<Pattern>();
    @Autowired
    private UserInfoInterface userInfoInterface;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String branchKey = request.getHeader("branch");
        branchKey = StringUtils.isBlank((CharSequence)branchKey) ? "develop" : branchKey;
        CurThreadInfoUtils.setBranchKey((String)branchKey);
        String token = request.getHeader("digi-middleware-auth-user");
        String routerKey = request.getHeader("routerKey");
        String tenantProcessId = request.getHeader("tenantProcessId");
        String level = request.getHeader("level");
        String locale = request.getHeader("locale");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            TenantInfo tenantInfo = this.userInfoInterface.parseTokenGetTenantInfo(token);
            CurThreadInfoUtils.setCurTokenTenant((TenantInfo)tenantInfo);
        }
        CurThreadInfoUtils.setLocale((String)(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{locale}) ? locale : "zh_CN"));
        CurThreadInfoUtils.setToken((String)token);
        CurThreadInfoUtils.setRouterKey((String)routerKey);
        CurThreadInfoUtils.setTemplateId((String)request.getHeader("templateId"));
        CurThreadInfoUtils.setAdpVersion((String)request.getHeader("adpVersion"));
        CurThreadInfoUtils.setAdpStatus((String)request.getHeader("adpStatus"));
        CurThreadInfoUtils.setPlatformSource((String)level);
        CurThreadInfoUtils.setTenantProcessId((String)tenantProcessId);
        String requestURI = request.getRequestURI();
        String individualCaseAppCode = request.getHeader("individualCaseAppCode");
        CurThreadInfoUtils.setIndividualCaseAppCode((String)individualCaseAppCode);
        String individualCase = request.getHeader("individualCase");
        if (!StringUtils.isEmpty((CharSequence)individualCase)) {
            Boolean individualCaseWhiteFlag = false;
            for (Pattern pattern : INDIVIDUAL_CASE_WHITE_PATTERN_URLS) {
                Matcher matcher = pattern.matcher(requestURI);
                individualCaseWhiteFlag = individualCaseWhiteFlag != false && matcher.matches();
            }
            if (!INDIVIDUAL_CASE_WHITE_URLS.contains(requestURI) && !individualCaseWhiteFlag.booleanValue()) {
                if (!StringUtils.isEmpty((CharSequence)individualCase)) {
                    CurThreadInfoUtils.setIndividualCase((Boolean)Boolean.valueOf(individualCase));
                }
            } else {
                CurThreadInfoUtils.setIndividualCase((Boolean)false);
            }
        } else {
            CurThreadInfoUtils.setIndividualCase((Boolean)false);
        }
        return true;
    }

    static {
        INDIVIDUAL_CASE_WHITE_URLS.add("/athena-designer/individualCaseApp/allJobs");
        INDIVIDUAL_CASE_WHITE_URLS.add("/athena-designer/modelDriver/modelAssign/queryForTargetList");
        INDIVIDUAL_CASE_WHITE_URLS.add("/athena-designer/modelDriver/modelAssign/queryListV2");
        INDIVIDUAL_CASE_WHITE_URLS.add("/athena-designer/modelDriver/modelAssign/getModelsAssociateWithNavigateKey");
        INDIVIDUAL_CASE_WHITE_URLS.add("/athena-designer/modelDriver/modelAssign/queryList");
        INDIVIDUAL_CASE_WHITE_URLS.add("/athena-designer/modelDriver/queryModelByCode");
    }
}

