package com.digiwin.athena.domain.pagedesign;

import com.digiwin.athena.http.iam.dto.IamTenantCustomInfo;
import com.digiwin.athena.http.iam.dto.TenantInfoDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @author liyuetao
 * @title: TenantInfo
 * @projectName athena_designer
 * @description: TODO
 * @date 2022/10/1715:37
 */
@Data
@Accessors(chain = true)
public class TenantInfo {
    @Schema(description = "租户id")
    private String tenantId;

    private Long tenantSid;

    @Schema(description = "客服代号")
    private String customId;

    @Schema(description = "云")
    private String serviceId;

    private String serviceName;

    @Schema(description = "租户名")
    private String tenantName;

    @Schema(description = "是否客户租户")
    private Boolean customerTenant;

    public static TenantInfo create(TenantInfoDto tenantInfoDto) {
        TenantInfo tenantInfo = new TenantInfo();
        tenantInfo.setTenantSid(tenantInfoDto.getTenantSid());
        tenantInfo.setTenantId(tenantInfoDto.getTenantId());
        tenantInfo.setTenantName(tenantInfoDto.getTenantName());
        tenantInfo.setCustomId(tenantInfoDto.getCustomerId());

        return tenantInfo;
    }

    public IamTenantCustomInfo convertIamTenantCustomInfo() {
        IamTenantCustomInfo iamTenantCustomInfo = new IamTenantCustomInfo();
        iamTenantCustomInfo.setCustomerId(customId);
        iamTenantCustomInfo.setId(this.tenantId);
        iamTenantCustomInfo.setSid(this.tenantSid);
        iamTenantCustomInfo.setName(this.tenantName);
        iamTenantCustomInfo.setTestTenant(!this.customerTenant);

        return iamTenantCustomInfo;
    }

    public Boolean judgeCustomerTenant(){

        return this.customerTenant != null && this.customerTenant;
    }
}
