package com.digiwin.athena.interceptor;

import com.digiwin.athena.config.BranchConfig;
import com.digiwin.athena.constant.Constant;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.service.UserInfoInterface;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Component
public class CurUserThreadInterceptor implements HandlerInterceptor {

    public static final Set<String> INDIVIDUAL_CASE_WHITE_URLS = new HashSet<>();
    public static final List<Pattern> INDIVIDUAL_CASE_WHITE_PATTERN_URLS = new ArrayList<>();
    static {
        INDIVIDUAL_CASE_WHITE_URLS.add("/athena-designer/individualCaseApp/allJobs");
        INDIVIDUAL_CASE_WHITE_URLS.add("/athena-designer/modelDriver/modelAssign/queryForTargetList");
        INDIVIDUAL_CASE_WHITE_URLS.add("/athena-designer/modelDriver/modelAssign/queryListV2");
        INDIVIDUAL_CASE_WHITE_URLS.add("/athena-designer/modelDriver/modelAssign/getModelsAssociateWithNavigateKey");
        INDIVIDUAL_CASE_WHITE_URLS.add("/athena-designer/modelDriver/modelAssign/queryList");
        INDIVIDUAL_CASE_WHITE_URLS.add("/athena-designer/modelDriver/queryModelByCode");
//        Pattern pattern = Pattern.compile("");
    }
    @Autowired
    private UserInfoInterface userInfoInterface;


    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String branchKey = request.getHeader(Constant.BRANCH_KEY);
        branchKey = StringUtils.isBlank(branchKey) ? BranchConfig.DEV_BRANCH_NAME : branchKey;
        CurThreadInfoUtils.setBranchKey(branchKey);

        String token = request.getHeader(Constant.IAM_TOKEN);
        String routerKey = request.getHeader(Constant.ROUTER_KEY);
        String tenantProcessId = request.getHeader(Constant.TENANT_PROCESS_ID);
        String level = request.getHeader(Constant.LEVEL);
        String locale = request.getHeader(Constant.LOCALE);

        if (StringUtils.isNotEmpty(token)) {
            TenantInfo tenantInfo = userInfoInterface.parseTokenGetTenantInfo(token);
            CurThreadInfoUtils.setCurTokenTenant(tenantInfo);
        }

        CurThreadInfoUtils.setLocale(StringUtils.isNoneBlank(locale)? locale : "zh_CN");
        CurThreadInfoUtils.setToken(token);
        CurThreadInfoUtils.setRouterKey(routerKey);
        CurThreadInfoUtils.setTemplateId(request.getHeader(Constant.TEMPLATE_ID));
        CurThreadInfoUtils.setAdpVersion(request.getHeader(Constant.ADP_VERSION));
        CurThreadInfoUtils.setAdpStatus(request.getHeader(Constant.ADP_STATUS));
        CurThreadInfoUtils.setPlatformSource(level);
        CurThreadInfoUtils.setTenantProcessId(tenantProcessId);

        String requestURI = request.getRequestURI();

        String individualCaseAppCode = request.getHeader(Constant.INDIVIDUAL_CASE_APP_CODE);
        CurThreadInfoUtils.setIndividualCaseAppCode(individualCaseAppCode);

        String individualCase = request.getHeader(Constant.INDIVIDUAL_CASE);
        if (!StringUtils.isEmpty(individualCase)) {

            Boolean individualCaseWhiteFlag = false;
            for (Pattern pattern : INDIVIDUAL_CASE_WHITE_PATTERN_URLS) {
                Matcher matcher = pattern.matcher(requestURI);
                individualCaseWhiteFlag = individualCaseWhiteFlag && matcher.matches();
            }

            if (!INDIVIDUAL_CASE_WHITE_URLS.contains(requestURI) && !individualCaseWhiteFlag) {

                if (!StringUtils.isEmpty(individualCase)) {
                    CurThreadInfoUtils.setIndividualCase(Boolean.valueOf(individualCase));
                }

            }else{
                CurThreadInfoUtils.setIndividualCase(false);
            }
        }else {
            CurThreadInfoUtils.setIndividualCase(false);
        }
        return true;
    }

}
