package com.digiwin.athena.utils.user;

import com.digiwin.athena.constant.Constant;
import com.digiwin.athena.mysql.domain.user.UserPO;
import com.digiwin.athena.service.UserInfoInterface;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.lang.reflect.Method;
import java.util.Date;

/**
 * @ClassName UserHelper
 * @Description TODO
 * @Author zhuangli
 * @Date 2022/6/16 14:51
 * @Version 1.0
 **/
@Slf4j
@Component
public class UserHelper implements ApplicationContextAware {
    private static UserInfoInterface userInfoInterface;

    private static final String SET_METHOD_PREFIX="set";
    public static UserPO getCurrentUser() {

        return userInfoInterface.getCurrentUser();
    }

    public static String getCurrentUserNameOrSystem() {
        try {
            UserPO user = getCurrentUser();
            return user.getName();
        } catch (Exception e) {
            return Constant.SYSTEM;
        }
    }

    public static String getCurrentIamToken() {
        return CurThreadInfoUtils.getToken();
    }

    public static <T> void fillCreateInfo(T t) {
        fillInfo(t, "createBy", "createDate");
    }

    public static <T> void fillEditInfo(T t) {
        fillInfo(t, "editBy", "editDate");
    }

    private static <T> void fillInfo(T t, String nameField, String timeField) {
        UserPO currentUser = null;
        try {
            currentUser = getCurrentUser();
        } catch (Exception e) {
            currentUser = new UserPO();
            currentUser.setName(Constant.SYSTEM);
        }

        if (currentUser == null) {
            currentUser = new UserPO();
            currentUser.setName(Constant.SYSTEM);
        }

        Class<?> clazz = t.getClass();
        Method[] methods = clazz.getMethods();

        String setNameMethod = String.format("%s%s", SET_METHOD_PREFIX, StringUtils.capitalize(nameField));
        String setTimeMethod = String.format("%s%s", SET_METHOD_PREFIX, StringUtils.capitalize(timeField));

        for (Method method : methods) {
            if (setNameMethod.equals(method.getName())){
                try {
                    method.invoke(t,currentUser.getName());
                } catch (Exception e) {
                    log.error("设置操作人信息失败：" + e.getMessage(), e);
                }
            }

            if (setTimeMethod.equals(method.getName())){
                try {
                    method.invoke(t,new Date());
                } catch (Exception e) {
                    log.error("设置操作人信息失败：" + e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        UserHelper.userInfoInterface= applicationContext.getBean(UserInfoInterface.class);
    }
}
