/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.utils.user;

import com.digiwin.athena.mysql.domain.user.UserPO;
import com.digiwin.athena.service.UserInfoInterface;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import java.lang.reflect.Method;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class UserHelper
implements ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserHelper.class);
    private static UserInfoInterface userInfoInterface;
    private static final String SET_METHOD_PREFIX = "set";

    public static UserPO getCurrentUser() {
        return userInfoInterface.getCurrentUser();
    }

    public static String getCurrentUserNameOrSystem() {
        try {
            UserPO user = UserHelper.getCurrentUser();
            return user.getName();
        }
        catch (Exception e) {
            return "SYSTEM";
        }
    }

    public static String getCurrentIamToken() {
        return CurThreadInfoUtils.getToken();
    }

    public static <T> void fillCreateInfo(T t) {
        UserHelper.fillInfo(t, "createBy", "createDate");
    }

    public static <T> void fillEditInfo(T t) {
        UserHelper.fillInfo(t, "editBy", "editDate");
    }

    private static <T> void fillInfo(T t, String nameField, String timeField) {
        UserPO currentUser = null;
        try {
            currentUser = UserHelper.getCurrentUser();
        }
        catch (Exception e) {
            currentUser = new UserPO();
            currentUser.setName("SYSTEM");
        }
        if (currentUser == null) {
            currentUser = new UserPO();
            currentUser.setName("SYSTEM");
        }
        Class<?> clazz = t.getClass();
        Method[] methods = clazz.getMethods();
        String setNameMethod = String.format("%s%s", SET_METHOD_PREFIX, StringUtils.capitalize((String)nameField));
        String setTimeMethod = String.format("%s%s", SET_METHOD_PREFIX, StringUtils.capitalize((String)timeField));
        for (Method method : methods) {
            if (setNameMethod.equals(method.getName())) {
                try {
                    method.invoke(t, currentUser.getName());
                }
                catch (Exception e) {
                    log.error("\u8bbe\u7f6e\u64cd\u4f5c\u4eba\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
            if (!setTimeMethod.equals(method.getName())) continue;
            try {
                method.invoke(t, new Date());
            }
            catch (Exception e) {
                log.error("\u8bbe\u7f6e\u64cd\u4f5c\u4eba\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        userInfoInterface = (UserInfoInterface)applicationContext.getBean(UserInfoInterface.class);
    }
}

