package com.digiwin.athena.dtdapp.dao.st;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.dtdapp.mapper.stmapper.WorkCalendarMapper;
import com.digiwin.athena.dtdapp.pojo.dto.st.WorkCalendarDTO;
import com.digiwin.athena.dtdapp.pojo.entity.st.WorkCalendar;
import com.digiwin.athena.dtdapp.pojo.vo.WorkCalendarInfos;
import com.digiwin.athena.dtdapp.pojo.vo.st.WorkCalendarVO;
import com.digiwin.athena.dtdapp.util.LoginUserUtils;
import com.digiwin.athena.dtdapp.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.tomcat.jni.Local;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;


@Service
@Slf4j
public class WorkCalendarDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkCalendarDAO.class);

    @Autowired
    private WorkCalendarMapper workCalendarMapper;

    public List getWorkCalendarInfo(JSONObject jsonObject) throws DWException {
        LOGGER.info("getWorkCalendarInfo:{}", jsonObject);
        WorkCalendar getWorkCalendar = null;
        List<WorkCalendar> workCalendars = new ArrayList<>();
        List<WorkCalendarVO> workCalendarVOS = new ArrayList<>();
        List<WorkCalendarInfos> workCalendarInfos = new ArrayList<>();
        if (jsonObject == null || jsonObject.isEmpty()) {
            WorkCalendarInfos cn = getWorkCalendarInfos("CN");

            WorkCalendarInfos tw = getWorkCalendarInfos("TW");
            workCalendarInfos.add(cn);
            workCalendarInfos.add(tw);
            return workCalendarInfos;
        }

        WorkCalendarDTO workCalendar = JSON.parseObject(JSON.toJSONString(jsonObject), WorkCalendarDTO.class);
        if (workCalendar.getAdjust_date() != null) {
            for (String date : workCalendar.getAdjust_date()) {
                LambdaQueryWrapper<WorkCalendar> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(workCalendar.getArea() != null, WorkCalendar::getArea, workCalendar.getArea());
                //queryWrapper.eq(workCalendar.getYear() != null, WorkCalendar::getYear, workCalendar.getYear());
                queryWrapper.eq(WorkCalendar::getAdjust_date, date);
                queryWrapper.eq(workCalendar.getAdjust_type() != null, WorkCalendar::getAdjust_type, workCalendar.getAdjust_type());
                queryWrapper.eq(workCalendar.getTenantsid() != null, WorkCalendar::getTenantsid, LoginUserUtils.getTenantSid());
                queryWrapper.orderByAsc(WorkCalendar::getAdjust_date);
                queryWrapper.eq(WorkCalendar::getTenantsid, LoginUserUtils.getTenantSid());
                getWorkCalendar = workCalendarMapper.selectOne(queryWrapper);
                if (getWorkCalendar != null) {
                    workCalendars.add(getWorkCalendar);
                } else {
                    DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                    LocalDate localDate = LocalDate.parse(date, df);
                    WorkCalendar workCalendar1 = new WorkCalendar();
                    workCalendar1.setArea(workCalendar.getArea());
                    workCalendar1.setYear(localDate.getYear() + "");
                    workCalendar1.setAdjust_date(date);
                    workCalendar1.setAdjust_type(isWorkday(localDate) ? "2" : "1");
                    workCalendars.add(workCalendar1);
                }
            }
        } else {
            LambdaQueryWrapper<WorkCalendar> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(workCalendar.getArea() != null, WorkCalendar::getArea, workCalendar.getArea());
//            queryWrapper.eq(workCalendar.getYear() != null, WorkCalendar::getYear, workCalendar.getYear());
            queryWrapper.eq(workCalendar.getAdjust_type() != null, WorkCalendar::getAdjust_type, workCalendar.getAdjust_type());
            queryWrapper.eq(WorkCalendar::getTenantsid, LoginUserUtils.getTenantSid());
            workCalendars = workCalendarMapper.selectList(queryWrapper);
        }

        workCalendars.stream().forEach(s -> {
            WorkCalendarVO workCalendarVO = new WorkCalendarVO();
            BeanUtils.copyProperties(s, workCalendarVO);
            workCalendarVO.setUibot_checked(false);
            workCalendarVOS.add(workCalendarVO);
        });

        WorkCalendarInfos workCalendarInfo = new WorkCalendarInfos();
        workCalendarInfo.setArea(workCalendar.getArea());
        workCalendarInfo.setWork_calendar_info(workCalendarVOS);
        workCalendarInfos.add(workCalendarInfo);

        return workCalendarInfos;
    }

    private WorkCalendarInfos getWorkCalendarInfos(String area) {
        List<WorkCalendar> workCalendars = new ArrayList<>();
        List<WorkCalendarVO> workCalendarVOS = new ArrayList<>();
        LambdaQueryWrapper<WorkCalendar> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(WorkCalendar::getArea, area);
        queryWrapper.eq(WorkCalendar::getTenantsid, LoginUserUtils.getTenantSid());
        queryWrapper.orderByAsc(WorkCalendar::getAdjust_date);
        workCalendars = workCalendarMapper.selectList(queryWrapper);
        workCalendars.stream().forEach(s -> {
            WorkCalendarVO workCalendarVO = new WorkCalendarVO();
            BeanUtils.copyProperties(s, workCalendarVO);
            workCalendarVO.setUibot_checked(false);
            workCalendarVOS.add(workCalendarVO);
        });
        WorkCalendarInfos workCalendarInfo = new WorkCalendarInfos();
        workCalendarInfo.setArea(area);
        workCalendarInfo.setWork_calendar_info(workCalendars);
        return workCalendarInfo;
    }

    private boolean isWorkday(LocalDate date) {
        DayOfWeek dayOfWeek = date.getDayOfWeek();
        return !dayOfWeek.equals(DayOfWeek.SATURDAY) && !dayOfWeek.equals(DayOfWeek.SUNDAY);
    }


    @Transactional
    public List createOrUpdateWorkCalendar(Map<String, String> parameter) throws DWException {
        LOGGER.info("getWorkCalendarInfo:{}", parameter);
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(parameter));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("work_calendar_info");
        if (jsonArray == null && jsonArray.size() == 0) {
            throw new DWException("workCalendar is empty");
        }
        List<WorkCalendar> workCalendars = JSON.parseArray(JSON.toJSONString(jsonArray), WorkCalendar.class);
        List<WorkCalendar> getWorkCalendars = new ArrayList<>();

        for (WorkCalendar workCalendar : workCalendars) {
            if (!StringUtils.isNotEmpty(workCalendar.getAdjust_date()) ) {
                throw new DWException("adjust_date is empty");
            }
            workCalendar.setYear(workCalendar.getAdjust_date().split("-")[0]);
            LambdaQueryWrapper<WorkCalendar> eq = new QueryWrapper<WorkCalendar>().lambda().eq(WorkCalendar::getAdjust_date, workCalendar.getAdjust_date())
                    .eq(WorkCalendar::getArea,workCalendar.getArea())
                    .eq(WorkCalendar::getYear,workCalendar.getYear())
                    .eq(WorkCalendar::getTenantsid, LoginUserUtils.getTenantSid());
            WorkCalendar getWorkCalendar = workCalendarMapper.selectOne(eq);
            if (getWorkCalendar != null) {
                workCalendarMapper.delete(eq);
            }
            workCalendarMapper.insert(workCalendar);

            eq =  new QueryWrapper<WorkCalendar>().lambda().eq(WorkCalendar::getAdjust_date, workCalendar.getAdjust_date())
                    .eq(WorkCalendar::getArea,workCalendar.getArea())
                    .eq(WorkCalendar::getYear,workCalendar.getYear())
                    .eq(WorkCalendar::getTenantsid, LoginUserUtils.getTenantSid());
            WorkCalendar getWorkCalendarOne = workCalendarMapper.selectOne(eq);
            getWorkCalendars.add(getWorkCalendarOne);
        }

        return getWorkCalendars;
    }
}
