package com.digiwin.athena.dtdapp.dao.zentao;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.dtdapp.mapperzentao.ZtDeptMapper;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtDept;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author
 * @version 1.0
 */
@Service
@Slf4j
public class ZtDeptDAO extends ServiceImpl<ZtDeptMapper, ZtDept> {

    @Autowired
    private ZtDeptMapper ztDeptMapper;

    /**
     * 根据部门id获取当前部门及子部门列表
     *
     * @param deptId 部门id
     * @return 返回
     */
    public List<ZtDept> queryDeptList(Integer deptId) {
        return ztDeptMapper.queryDeptList(deptId);
    }
}
