package com.digiwin.athena.dtdapp.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.dtdapp.pojo.dto.zt.ZtBugWarningDTO;
import com.digiwin.athena.dtdapp.pojo.entity.OpinionsInfo;
import io.lettuce.core.ScanIterator;
import org.apache.ibatis.annotations.*;

import java.util.List;

public interface AnonymousOpinionsMapper extends BaseMapper<OpinionsInfo> {

    @Insert("INSERT INTO anonymous_opinions_info(status, apply_name, problem_description, follow_up_call, recipient_id, email_address, create_by, tenantSid, create_date) " +
            "VALUES (#{opinionsInfo.status}, #{opinionsInfo.apply_name}, HEX(AES_ENCRYPT(#{opinionsInfo.problem_description}, #{aesKey})), #{opinionsInfo.follow_up_call}, #{opinionsInfo.recipient_id}, #{opinionsInfo.email_address}, #{opinionsInfo.create_by}, #{opinionsInfo.tenantSid}, #{opinionsInfo.create_date})")
    void insertAEC(@Param("opinionsInfo") OpinionsInfo opinionsInfo, @Param("aesKey") String aesKey);

    @Results({
            @Result(property = "status", column = "status"),
            @Result(property = "problem_description", column = "problem_description"),
            @Result(property = "follow_up_call", column = "follow_up_call"),
            @Result(property = "recipient_id", column = "recipient_id"),
            @Result(property = "email_address", column = "email_address"),
            @Result(property = "create_by", column = "create_by"),
            @Result(property = "tenantSid", column = "tenantSid"),
            @Result(property = "create_date", column = "create_date"),
            @Result(property = "apply_name", column = "apply_name")
    })
    @Select("SELECT status, CAST(AES_DECRYPT(UNHEX(problem_description), #{aesKey}) AS CHAR) AS problem_description, follow_up_call, recipient_id, email_address, create_by, tenantSid, create_date, AES_DECRYPT(UNHEX(problem_description), #{aesKey}) AS apply_name " +
            "FROM anonymous_opinions_info WHERE recipient_id = #{recipientId} ORDER BY create_date DESC")
    List<OpinionsInfo> selectListAEC(Long recipientId,String aesKey);
}
