package com.digiwin.athena.dtdapp.mapperzentao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProduct;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProject;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtProjectVO;

import java.util.List;

/**
 * @author
 * @version 1.0
 */
public interface ZtProjectMapper extends BaseMapper<ZtProject> {

    List<ZtProject> getProgram();

    List<ZtProject> getProjectByProgramAndType(String parentId, String type);

    int getProjectCountByProjectId(String projectId);

    List<ZtProjectVO> getProjectByProgramAndProject(List<Integer> projectIds, Integer page, Integer size);

    /**
     * 根据项目集id查询当前项目集及子项目集列表
     *
     * @param programId 项目集id
     * @return 返回
     */
    List<ZtProject> queryProgramList(Integer programId);

    /**
     * 根据项目集id查询当前项目集下的项目列表
     *
     * @param programId 项目集id
     * @return 返回
     */
    List<ZtProject> queryProjectList(Integer programId);

    /**
     * 根据项目集id或项目id查询当前所有冲刺
     *
     * @param id 项目集id或项目id
     * @return 返回
     */
    List<ZtProject> querySprintList(Integer id);
}
