package com.digiwin.athena.dtdapp.pojo.dto.ztkanban;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 查询用户任务列表 请求对象
 *
 * @author sungqz
 * @since 2025-06-12
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
public class queryTaskReq implements Serializable {

    private static final long serialVersionUID = -1457589150106351469L;

    /**
     * 部门id
     */
    private Integer deptId;

    /**
     * 岗位(角色)
     */
    private String role;

    /**
     * 用户id
     */
    private String account;

    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

    /**
     * 项目集id
     */
    private Integer programId;

    /**
     * 项目id
     */
    private Integer projectId;

    /**
     * 项目id列表
     */
    private List<Integer> projectIdList;

    /**
     * 冲刺id
     */
    private Integer sprintId;
}
