package com.digiwin.athena.dtdapp.pojo.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.google.gson.annotations.SerializedName;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@Data
@TableName("anonymous_opinions_info")
@Accessors(chain = true)
public class OpinionsInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 匿名状态
     */
    private String status;
    /**
     * 应用名称
     */
    private String apply_name;
    /**
     * 问题描述
     */
    private String problem_description;
    /**
     * 回访电话
     */
    private String follow_up_call;
    /**
     * 收信人id
     */
    private Long recipient_id;
    /**
     * 收信人邮箱
     */
    private String email_address;
    /**
     * 创建人
     */
    private String create_by;
    /**
     * 租户id
     */
    @SerializedName("tenantsid")
    private String tenantSid;
    /**
     * 创建时间
     */
    private Date create_date;

}

