package com.digiwin.athena.dtdapp.pojo.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;

@Getter
public enum Status {
    Anonymous("0", "匿名"),
    Non_Anonymous("1", "非匿名"),
    Easy_Flow_Pending("1","待签核"),
    Easy_Flow_Process ("2","签核中"),
    Easy_Flow_Approval ("1","签核完成"),
    Purchase_Process("1","采购过程中"),
    Purchase_Approval("2","采购完成"),
    Purchase_Cancel("3","采购取消"),
    Temp_Pre("1","预存状态"),
    Temp_Submit("2","提交转态"),
    Supplier_Tradable("1","可交易"),
    Supplier_Deactivate("2","停用"),
    Supplier_Non ("3","不可交易"),
    Normal_State ("1","正常状态"),
    Abnormal_State ("2","异常状态"),
    Unprocessed_State ("3","未处理"),

    Wait_State("wait","未开始"),
    Doing_State("doing","进行中"),
    Done_State("done","已完成"),
    Pause_State("pause","已暂停"),
    Cancel_State("cancel","已取消"),
    Closed_State("closed","已关闭"),

    Wait_Audit("0","待审核"),
    Approved("1","审核通过"),
    Review_rejection("2","审核拒绝"),

    WORK_REPORT_NO_DELETE("0","未删除"),
    WORK_REPORT_DELETE("1","已删除"),

    NOTHING("nothing","无"),
    INTERMEDIATE("intermediate","中级"),
    PRIMARY("primary","初级"),
    SENIOR("senior","高级"),
    ZIYI("ziyi","资一"),
    ZIER("zier","资二"),
    ZISAN("zisan","姿三"),

    PROBATION("probation","试用期"),
    BEFORMAL("beformal","转正"),
    DEPART("quit","离职"),
    NOUSED("return","不可转正"),

    FORMAL("formal","正式"),
    OUTSOURCE("outsource","外包"),
    PRACTICE("practice","实习"),

    three("3","三个月"),
    six("6","六个月"),

    PM("PM","PM"),
    PMO("PMO","PMO"),
    PO("PO","PO"),
    PR("PR","PR"),
    QA("QA","QA"),
    QC("QC","QC"),
    UIUX("UIUX","设计（UI/UX）"),
    VP("VP","VP"),
    ARCHITECTURE("architecture","架构"),
    OPERATION("operation","运维"),
    plan_adviser("plan_adviser","赋能规划顾问"),
    plan_develop("plan_develop","赋能开发顾问"),

    Retain("retain","留用"),
    Return("return","退回")
    ;


    @JsonValue
    @EnumValue
    String value;
    String desc;

    Status(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    public static String fromValue(String value) {
        for (Status status : Status.values()) {
            if (status.getValue().equals(value)) {
                return status.getDesc();
            }
        }
        return null;
    }
}
