package com.digiwin.athena.dtdapp.pojo.vo.zentaoplus;

import lombok.Getter;
import lombok.Setter;

import java.util.LinkedHashMap;
import java.util.Map;

@Setter
@Getter
public class ProjectTeamDetailVo {

    public ProjectTeamDetailVo(String userName, String role) {
        this.userName = userName;
        this.role = role;
    }

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 用户角色 pm 产品经理， po 产品负责人， dev 开发， qa 测试, td 技术总监, SM scrum master,
     * others 其他, SA 系统分析师, techleader 技术负责人, qd 质量负责人, support 支持, operation 运维, QA1 测试, pd 产品
     */
    private String role;

    /**
     * 用户预估工时总计
     */
    private double estimate;

    /**
     * 用户消耗工时总计
     */
    private double consumed;

    /**
     * 日期对应的预估工时，会返回所有日期，如果没有工时则为 0，例如 2024-07-11: 0
     */
    private final Map<String, Double> dateEstimate = new LinkedHashMap<>();

    /**
     * 日期对应的消耗工时，会返回所有日期，如果没有工时则为 0，例如 2024-07-11: 0
     */
    private final Map<String, Double> dateConsumed = new LinkedHashMap<>();

}
