package com.digiwin.athena.dtdapp.pojo.vo.ztkanban;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 人力看板-任务项目信息
 *
 * @author sungqz
 * @since 2025-06-13
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ZtTaskProjectVO implements Serializable {

    private static final long serialVersionUID = 7495288792967905608L;

    /**
     * 任务id
     */
    private Integer id;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目计划开始时间
     */
    private LocalDate projectBegin;

    /**
     * 项目计划完成时间
     */
    private LocalDate projectEnd;

    /**
     * 项目状态 closed：已关闭 doing：进行中 wait：等待中 suspended：已暂停
     */
    private String projectStatus;

    /**
     * 迭代(执行、冲刺)id
     */
    private Integer execution;

    /**
     * 迭代名称
     */
    private String executionName;

    /**
     * 冲刺计划开始时间
     */
    private LocalDate executionBegin;

    /**
     * 冲刺计划完成时间
     */
    private LocalDate executionEnd;

    /**
     * 任务名称
     */
    private String name;

    /**
     * 任务类型code
     */
    private String type;

    /**
     * 任务类型名称
     */
    private String typeName;

    /**
     * 计划工期
     */
    private BigDecimal estimate;

    /**
     * 实际工期
     */
    private BigDecimal consumed;

    /**
     * 剩余工期
     */
    private Float left;

    /**
     * 计划开始时间
     */
    private LocalDate estStarted;

    /**
     * 计划开始时间 字符串
     */
    private String estStartedStr;

    /**
     * 计划完成时间
     */
    private LocalDate deadline;

    /**
     * 计划完成时间 字符串
     */
    private String deadlineStr;

    /**
     * 指派人
     */
    private String assignedTO;

    /**
     * 完成人
     */
    private String finishedBy;

    /**
     * 用户名称
     */
    private String realname;

    /**
     * 用户角色
     */
    private String role;

    /**
     * 实际开始时间
     */
    private LocalDateTime realStarted;

    /**
     * 实际完成时间
     */
    private LocalDateTime finishedDate;

    /**
     * 创建时间
     */
    private LocalDateTime openedDate;

    /**
     * 任务进度
     */
    private String taskProgress;

    /**
     * 工时偏差率
     */
    private String workHourDeviationRate;

    /**
     * 预计利用率
     */
    private String expectedUtilizationRate;

    /**
     * 实际利用率
     */
    private String actualUtilizationRate;
}
