package com.digiwin.athena.dtdapp.pojo.vo.ztkanban;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 人力看板-任务汇总行 对象实体
 *
 * @author sungqz
 * @since 2025-06-12
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ZtTaskTotalVO implements Serializable {

    private static final long serialVersionUID = -7127297678294000179L;

    /**
     * 项目id
     */
    private List<String> projectIdList;

    /**
     * 项目名称
     */
    private List<String> projectNameList;

    /**
     * 任务进度
     */
    private String taskProgress;

    /**
     * 最早计划开始时间
     */
    private LocalDate earliestEstStarted;

    /**
     * 最早计划开始时间 字符串
     */
    private String earliestEstStartedStr;

    /**
     * 最晚计划完成时间
     */
    private LocalDate latestDeadline;

    /**
     * 最晚计划完成时间 字符串
     */
    private String latestDeadlineStr;

    /**
     * 最早实际开始时间
     */
    private LocalDateTime earliestRealStarted;

    /**
     * 最晚实际完成时间
     */
    private LocalDateTime latestFinishedDate;

    /**
     * 计划工期
     */
    private BigDecimal estimate;

    /**
     * 实际工期
     */
    private BigDecimal consumed;

    /**
     * 工时偏差率
     */
    private String workHourDeviationRate;

    /**
     * 预计利用率
     */
    private String expectedUtilizationRate;

    /**
     * 实际利用率
     */
    private String actualUtilizationRate;
}
