package com.digiwin.athena.dtdapp.provider;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestBodyParam;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.dtdapp.pojo.dto.OpinionsInfoDTO;
import com.digiwin.athena.dtdapp.pojo.dto.zt.ZtBugWarningDTO;
import com.digiwin.athena.dtdapp.pojo.entity.OpinionsInfo;
import com.digiwin.athena.dtdapp.pojo.vo.OpinionsInfoVO;
import com.digiwin.athena.dtdapp.pojo.vo.RecipientInfoVO;
import org.json.JSONObject;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.List;

@DWRestfulService
public interface IAnonymousOpinionsService extends DWService {
    /**
     * 创建匿名意见
     */
    @DWRequestMapping(path = "/opinions/create/anonymous", method = {DWRequestMethod.POST})
    @AllowAnonymous
    void addAnonymousOpinions(@RequestBody OpinionsInfoDTO opinionsInfoDTO) throws Exception;
    /**
     * 创建实名意见
     */
    @DWRequestMapping(path = "/opinions/create/real_name", method = {DWRequestMethod.POST})
    void addRealNameOpinions(@RequestBody OpinionsInfoDTO opinionsInfoDTO) throws Exception;
    /**
     * 收信人意见获取
     */
    @DWRequestMapping(path = "/opinions/get", method = {DWRequestMethod.POST})
    List<OpinionsInfoVO> getOpinions() throws Exception;

    /**
     * 收信人信息
     */
    @DWRequestMapping(path = "/opinions/recipient", method = {DWRequestMethod.POST})
    @AllowAnonymous
    List<RecipientInfoVO> getRecipient() throws Exception;

    @DWRequestMapping(path = "/sendEmail", method = {DWRequestMethod.POST})
    @AllowAnonymous
    void sendEmailToSm();
}
