package com.digiwin.athena.dtdapp.provider;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWFile;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.dtdapp.pojo.vo.publish.CompareEnv;
import com.digiwin.athena.dtdapp.pojo.vo.publish.PublishRequest;

import java.util.Map;

@DWRestfulService
public interface IPublishService extends DWService {


    @DWRequestMapping(path = "/publish/espActionByProduct", method = {DWRequestMethod.POST})
    @AllowAnonymous
    Object publishEspActionByProduct(PublishRequest publishRequest);

    @DWRequestMapping(path = "/publish/espActionByService", method = {DWRequestMethod.POST})
    @AllowAnonymous
    Object publishEspActionByService(PublishRequest publishRequest);



    @DWRequestMapping(path = "/publish/generateActionScriptByProduct", method = {DWRequestMethod.POST})
    @AllowAnonymous
    Object generateActionScriptByProduct(PublishRequest publishRequest);

    @DWRequestMapping(path = "/publish/generateActionScriptByService", method = {DWRequestMethod.POST})
    @AllowAnonymous
    Object generateActionScriptByService(PublishRequest publishRequest);


    @DWRequestMapping(path = "/publish/executeNeo4jScript", method = {DWRequestMethod.POST})
    @AllowAnonymous
    Object executeNeo4jScript(DWFile dwFile);



    @DWRequestMapping(path = "/publish/compareEnv", method = {DWRequestMethod.POST})
    @AllowAnonymous
    Object compareEnv(CompareEnv compareEnv);
}
