package com.digiwin.athena.dtdapp.provider.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWException;

import com.digiwin.athena.dtdapp.dao.AnonymousOpinionsDAO;
import com.digiwin.athena.dtdapp.mapper.RecipientMapper;
import com.digiwin.athena.dtdapp.pojo.dto.BugEmailInfoDTO;
import com.digiwin.athena.dtdapp.pojo.dto.OpinionsInfoDTO;
import com.digiwin.athena.dtdapp.pojo.dto.zt.ZtBugWarningDTO;
import com.digiwin.athena.dtdapp.pojo.entity.DeptEmail;
import com.digiwin.athena.dtdapp.pojo.entity.OpinionsInfo;
import com.digiwin.athena.dtdapp.pojo.entity.RecipientInfo;
import com.digiwin.athena.dtdapp.pojo.vo.OpinionsInfoVO;
import com.digiwin.athena.dtdapp.pojo.vo.RecipientInfoVO;
import com.digiwin.athena.dtdapp.provider.IAnonymousOpinionsService;

import com.digiwin.athena.dtdapp.util.DateUtils;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.crypto.spec.SecretKeySpec;
import java.security.Key;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class IAnonymousOpinionsImpl implements IAnonymousOpinionsService {
    @Autowired
    private AnonymousOpinionsDAO anonymousOpinionsDAO;
    @Autowired
    private RecipientMapper recipientMapper;

    @Override
    public void addAnonymousOpinions(OpinionsInfoDTO opinionsInfoDTO) throws Exception {
        insertOpinionsInfo(opinionsInfoDTO);
    }

    @Override
    public void addRealNameOpinions(OpinionsInfoDTO opinionsInfoDTO) throws Exception {
        insertOpinionsInfo(opinionsInfoDTO);
    }

    @Override
    public List<OpinionsInfoVO> getOpinions() throws Exception {

        return anonymousOpinionsDAO.getOpinions();
    }

    @Override
    public List<RecipientInfoVO> getRecipient() throws Exception {

        return anonymousOpinionsDAO.getRecipient();
    }

    private void insertOpinionsInfo(OpinionsInfoDTO opinionsInfoDTO) throws DWException {
        if (ObjectUtils.isEmpty(opinionsInfoDTO.getProblem_description())) {
            throw new DWException(" problem_description is empty");
        }
        if (ObjectUtils.isEmpty(opinionsInfoDTO.getRecipientInfo())) {
            throw new DWException(" recipientInfo is empty");
        }
        Map<Long, String> recipientInfo = opinionsInfoDTO.getRecipientInfo();
        for (Long recipient_id : recipientInfo.keySet()) {
            QueryWrapper<RecipientInfo> recipientInfoQueryWrapper = new QueryWrapper<>();
            recipientInfoQueryWrapper.eq("email_address", recipientInfo.get(recipient_id));
            RecipientInfo recipientInfo1 = recipientMapper.selectOne(recipientInfoQueryWrapper);
            if (recipientInfo1 == null || recipient_id != recipientInfo1.getRecipient_id()) {
                throw new RuntimeException("收信人不存在或信息不符合!");
            }
        }
        anonymousOpinionsDAO.insertOpinionsInfo(opinionsInfoDTO);
        //发送邮件
        sendEmail(opinionsInfoDTO);
    }


    private static void sendEmail(OpinionsInfoDTO opinionsInfoDTO) {

        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.set(DWRequestHeaderUtils.HEADER_IAM_API_APP_TOKEN,
                DWApplicationConfigUtils.getProperty("iamApToken"));
        headers.set("Content-Type", "application/json");
        String tApi = "/api/emc/v1/message/sendEmail";
        Map<String, Object> tRequest = new HashMap<>();
        ArrayList<String> list = new ArrayList<>();
        list.addAll(opinionsInfoDTO.getRecipientInfo().values());
        tRequest.put("userIds", list);
        tRequest.put("msgType", "text");
        tRequest.put("title", "您有一份新的反馈信息");
        //获取请求域名
        String feedbackFrontUrl = DWApplicationConfigUtils.getProperty("feedbackFrontUrl");
        log.info("域名:{}", feedbackFrontUrl);
        tRequest.put("content", "您有新的反馈信息，请至：<a href=\"" + feedbackFrontUrl + "\">反馈系统</a>查看！");
        HttpEntity<?> httpEntity = new HttpEntity<>(tRequest, headers);

        String tFinalUrl = DWApplicationConfigUtils.getProperty("emcUrl") + tApi;
        log.info("sendemcUrl:" + tFinalUrl);

        ResponseEntity<String> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(tFinalUrl, HttpMethod.POST, httpEntity, String.class);
        } catch (RestClientException e) {
            log.info(String.valueOf(e));
        }
        int statusCodeValue = responseEntity.getStatusCodeValue();
        if (statusCodeValue != 200) {
            String body = responseEntity.getBody();
            log.error("send mail error:{}-{}", statusCodeValue, body);

        }
    }

    @Override
    @Scheduled(cron = "0 0 8 * * ?")
    public void sendEmailToSm() {
        OpinionsInfoDTO opinionsInfoDTO = new OpinionsInfoDTO();
        List<ZtBugWarningDTO> allNormalBugs = anonymousOpinionsDAO.findAllNormalBugs();
        List<ZtBugWarningDTO> allExternalBugs = anonymousOpinionsDAO.findAllExternalBugs();
        List<ZtBugWarningDTO> allSeriousBugs = anonymousOpinionsDAO.findAllSeriousBugs();
        List<ZtBugWarningDTO> allBugs = new ArrayList<>();
        if (!CollectionUtils.isEmpty(allNormalBugs)){
            List<ZtBugWarningDTO> ztBugWarningDTOS = allNormalBugs.stream().filter(x -> {
                String createTime = x.getCreateTime();
                LocalDate openTime = DateUtils.convertStringToLocalDate(createTime);
                long days = DateUtils.calculateWorkingDays(openTime, LocalDate.now());
                if (days > 2) {
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            allBugs.addAll(ztBugWarningDTOS);
        }
        if (!CollectionUtils.isEmpty(allExternalBugs)){
            allBugs.addAll(allExternalBugs);
        }
        if (!CollectionUtils.isEmpty(allSeriousBugs)){
            allBugs.addAll(allSeriousBugs);
        }

        List<DeptEmail> emailInfo = anonymousOpinionsDAO.getEmailInfo();
        Map<String, List<ZtBugWarningDTO>> bugByDept = allBugs.stream().filter(x->!StringUtils.isEmpty(x.getAssignedDepartment())).collect(Collectors.groupingBy(ZtBugWarningDTO::getAssignedDepartment));
        Map<String, List<DeptEmail>> email = emailInfo.stream().collect(Collectors.groupingBy(DeptEmail::getDept));
        for (Map.Entry<String, List<DeptEmail>> emailInfoMap : email.entrySet()) {
            String key = emailInfoMap.getKey();
            List<ZtBugWarningDTO> ztBugWarningDTOS = bugByDept.get(key);
            if (!CollectionUtils.isEmpty(ztBugWarningDTOS)) {
                List<DeptEmail> deptEmails = email.get(key);
                BugEmailInfoDTO bugEmailInfoDTO = new BugEmailInfoDTO();
                bugEmailInfoDTO.setEmail(deptEmails.get(0).getEmail());
                int size = ztBugWarningDTOS.size();
                String bugNum = ztBugWarningDTOS.stream().map(x -> "<li><h2 style=\"color:#faad14\">" + x.getBugNum()+" - "+x.getReceiver()+"</h2></li>").collect(Collectors.joining());
                String content = "<h2>尊敬的%sSM：</h2>" +
                        "<h2>目前共有<span style=\"color:#ff4d4f\">%s</span>张单据即将超期，请及时通知相关同事进行处理。</h2>" +
                        "<h2>具体单据信息如下：</h2>" +
                        "<ul>%s</ul>" +
                        "<h2>如有疑问，请随时联系维护组SM尚丹丹。</h2>";
                String msg = String.format(content, key, size, bugNum);
                bugEmailInfoDTO.setMsg(msg);
                sendEmailForBug(bugEmailInfoDTO);
            }
        }

    }

    private static void sendEmailForBug(BugEmailInfoDTO bugEmailInfoDTO) {

        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.set(DWRequestHeaderUtils.HEADER_IAM_API_APP_TOKEN,
                DWApplicationConfigUtils.getProperty("iamApToken"));
        headers.set("Content-Type", "application/json");
        String tApi = "/api/emc/v1/message/sendEmail";
        Map<String, Object> tRequest = new HashMap<>();
        ArrayList<String> list = new ArrayList<>();
        list.addAll(Arrays.asList(bugEmailInfoDTO.getEmail()));
        tRequest.put("userIds", list);
        tRequest.put("msgType", "text");
        tRequest.put("title", "【来自运营管理系统的临期单据提醒】");
        tRequest.put("content", bugEmailInfoDTO.getMsg());
        HttpEntity<?> httpEntity = new HttpEntity<>(tRequest, headers);

        String tFinalUrl = DWApplicationConfigUtils.getProperty("emcUrl") + tApi;
        log.info("sendemcUrl:" + tFinalUrl);

        ResponseEntity<String> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(tFinalUrl, HttpMethod.POST, httpEntity, String.class);
        } catch (RestClientException e) {
            log.info(String.valueOf(e));
        }
        int statusCodeValue = responseEntity.getStatusCodeValue();
        if (statusCodeValue != 200) {
            String body = responseEntity.getBody();
            log.error("send mail error:{}-{}", statusCodeValue, body);

        }
    }
}
