package com.digiwin.athena.dtdapp.provider.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.dtdapp.dao.st.WorkCalendarDAO;
import com.digiwin.athena.dtdapp.pojo.entity.st.Employee;
import com.digiwin.athena.dtdapp.pojo.entity.st.WorkReportDetail;
import com.digiwin.athena.dtdapp.pojo.vo.st.WorkReportDetailVO;
import com.digiwin.athena.dtdapp.provider.IWorkReportProvider;
import com.digiwin.athena.dtdapp.service.DtdappEocService;
import com.digiwin.athena.dtdapp.service.WorkReportService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
public class WorkReportProviderImpl implements IWorkReportProvider {

    @Autowired
    private WorkReportService workReportService;

    @Autowired
    private WorkCalendarDAO workCalendarDAO;
    @Autowired
    private DtdappEocService eocService;

    @Override
    public DWEAIResult postQueryEmployeeInfo(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);

        Map map1 = workReportService.queryEmployeeInfo(map);
        Map<String, Object> info = new HashMap<>();
        //info.put("employee_info", list);
        return new DWEAIResult("0", "0", "OK", map1);
    }

    @Override
    public DWEAIResult updateEmployeeInfo(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);

        List list = workReportService.updateEmployeeInfo(map);
        Map<String, Object> info = new HashMap<>();
        info.put("employee_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult queryOrganizationInfo(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);

        List list = workReportService.queryOrgInfo(map);
        Map<String, Object> info = new HashMap<>();
        info.put("org_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }


    @Override
    public DWEAIResult getWorkCalendarInfo(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        Map<String, Object> info = new HashMap<>();

        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        JSONObject jsonObject = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONObject("work_calendar_info");

        List workCalendarInfo = workCalendarDAO.getWorkCalendarInfo(jsonObject);
        info.put("work_calendar_infos", workCalendarInfo);
        return new DWEAIResult("0", "0", "OK", info);
    }


    @Override
    public DWEAIResult createOrUpdateWorkCalendar(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        Map<String, Object> info = new HashMap<>();
        List workCalendarInfo = workCalendarDAO.createOrUpdateWorkCalendar(map);
        info.put("work_calendar_info", workCalendarInfo);
        return new DWEAIResult("0", "0", "OK", info);

    }

    /**
     * 项目信息查询
     *
     * @param headers
     * @param messageBody
     * @return
     * @throws DWException
     */
    @Override
    public DWEAIResult getProjectInfo(Map<String, String> headers, String messageBody) throws DWException {
        Map map = JSON.parseObject(messageBody, Map.class);
        HashMap<String, Object> info = new HashMap<>();
        Map projectInfo = workReportService.queryProject(map);

        return new DWEAIResult("0", "0", "OK", projectInfo);
    }

    @Override
    public DWEAIResult updateProjectInfo(Map<String, String> headers, String messageBody) throws DWException {
        Map map = JSON.parseObject(messageBody, Map.class);
        HashMap<String, Object> info = new HashMap<>();
        List projectInfo = workReportService.updateProject(map);
        info.put("project_info", projectInfo);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult updateProjectStatusY(Map<String, String> headers, String messageBody) throws DWException {
        Map map = JSON.parseObject(messageBody, Map.class);
        HashMap<String, Object> info = new HashMap<>();
        List projectInfo = workReportService.updateProjectStatus(map, "Y");
        info.put("project_info", projectInfo);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult updateProjectStatusV(Map<String, String> headers, String messageBody) throws DWException {
        Map map = JSON.parseObject(messageBody, Map.class);
        HashMap<String, Object> info = new HashMap<>();
        List projectInfo = workReportService.updateProjectStatus(map, "V");
        info.put("project_info", projectInfo);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult createProjectInfo(Map<String, String> headers, String messageBody) throws DWException {
        Map map = JSON.parseObject(messageBody, Map.class);
        HashMap<String, Object> info = new HashMap<>();
        List projectInfo = workReportService.createProject(map);
        info.put("project_info", projectInfo);
        return new DWEAIResult("0", "0", "OK", info);
    }


    @Override
    public DWEAIResult queryWorkReportInfo(Map<String, String> headers, String messageBody) throws DWException {
        Map map = JSON.parseObject(messageBody, Map.class);
        HashMap<String, Object> info = new HashMap<>();
        List<WorkReportDetailVO> workReportInfo = workReportService.queryWorkReportInfo(map);
        info.put("work_report_info", workReportInfo);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult CreateOrUpdateWorkReportInfo(Map<String, String> headers, String messageBody) throws DWException, ParseException {
        Map map = JSON.parseObject(messageBody, Map.class);
        HashMap<String, Object> info = new HashMap<>();
        List workReportInfo = workReportService.CreateOrUpdateWorkReportInfo(map, "0");
        info.put("work_report_info", workReportInfo);
        return new DWEAIResult("0", "0", "OK", info);

    }

    @Override
    public DWEAIResult saveWorkReportInfo(Map<String, String> headers, String messageBody) throws DWException, ParseException {
        Map map = JSON.parseObject(messageBody, Map.class);
        HashMap<String, Object> info = new HashMap<>();
        List workReportInfo = workReportService.CreateOrUpdateWorkReportInfo(map, "3");
        info.put("work_report_info", workReportInfo);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult deleteWorkReportInfo(Map<String, String> headers, String messageBody) throws DWException {
        Map map = JSON.parseObject(messageBody, Map.class);
        HashMap<String, Object> info = new HashMap<>();
        List workReportInfo = workReportService.deleteWorkReportInfo(map);
        info.put("work_report_info", workReportInfo);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult auditWorkReportInfo(Map<String, String> headers, String messageBody) throws DWException {
        Map map = JSON.parseObject(messageBody, Map.class);
        HashMap<String, Object> info = new HashMap<>();
        List workReportInfo = workReportService.auditWorkReportInfo(map);
        info.put("work_report_info", workReportInfo);
        return new DWEAIResult("0", "0", "OK", info);

    }

    @Override
    public DWEAIResult needAuditWorkReportInfo(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSON.parseObject(messageBody, Map.class);
        HashMap<String, Object> info = new HashMap<>();
        List<WorkReportDetail> workReportInfo = workReportService.queryNeedAuditWorkReportInfo(map);
        info.put("work_report_infos", workReportInfo);
        return new DWEAIResult("0", "0", "OK", info);
    }


    @Override
    public DWEAIResult getWarningWorkReportInfo(Map<String, String> headers, String messageBody) throws DWException {
        Map map = JSON.parseObject(messageBody, Map.class);
        HashMap<String, Object> info = new HashMap<>();
        List<WorkReportDetail> workReportInfo = workReportService.getWarningWorkReportInfo(map);
        info.put("work_report_info", workReportInfo);
        return new DWEAIResult("0", "0", "OK", info);
    }


    @Override
    public DWEAIResult updateWarningWorkReportInfo(Map<String, String> headers, String messageBody) throws DWException {
        return null;
    }

    @Override
    public DWEAIResult getApproverInfo(Map<String, String> headers, String messageBody) throws DWException {
        Map map = JSON.parseObject(messageBody, Map.class);
        HashMap<String, Object> info = new HashMap<>();
        List<Employee> workReportInfo = workReportService.getApproverInfo(map);
        info.put("Approver_info", workReportInfo);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult getWorkReportByStatus(Map<String, String> headers, String messageBody) throws DWException {
        Map map = JSON.parseObject(messageBody, Map.class);
        HashMap<String, Object> info = new HashMap<>();
        List<Employee> workReportInfo = workReportService.getWorkReportByStatus(map);
        info.put("work_report_info", workReportInfo);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult insertOrUpdateEmployee(Map<String, String> headers, String messageBody) throws DWException {
        try {
            eocService.insertEmployeeInfo();
            return new DWEAIResult("0", "0", "OK", null);
        } catch (Exception e) {
            log.info(e.getMessage());
            throw new DWException();
        }
    }

    @Override
    public DWEAIResult insertOrUpdateDept(Map<String, String> headers, String messageBody) throws DWException {
        try {
            eocService.insertDeptInfo();
            return new DWEAIResult("0", "0", "OK", null);
        } catch (Exception e) {
            throw new DWException("部门插入更新失败");
        }
    }

    @Override
    public DWEAIResult getHistoryWorkReport(Map<String, String> headers, String messageBody) throws DWException {
        Map map = JSON.parseObject(messageBody, Map.class);
        Map<String, Object> workReportInfo = workReportService.getHistoryWorkReport(map);
        return new DWEAIResult("0", "0", "OK", workReportInfo);
    }

    @Override
    public DWEAIResult updateZtProject() throws DWException {
        try {
            DWServiceContext currentContext = DWServiceContext.getContext().deepClone();
            String currentModule = DWModuleClassLoader.getCurrentModuleName();
            new Thread(() -> {
                    synchronized(this) {
                        DWServiceContext.setContext(currentContext);
                        DWModuleClassLoader.setCurrentModuleName(currentModule);
                        workReportService.updateZtProduct();
                        workReportService.updateZtProject();
                    }
                }).start();
        } catch (Exception e) {
            throw new DWException("项目更新失败");
        }
        return new DWEAIResult("0", "0", "OK", null);
    }


    public DWEAIResult getZtWorkReport(Map<String, String> headers, String messageBody) throws DWException {
        Map map = JSON.parseObject(messageBody, Map.class);
        HashMap<String, Object> info = new HashMap<>();
        List workReportInfo = workReportService.getZtWorkReport(map);
        info.put("work_report_info", workReportInfo);
        return new DWEAIResult("0", "0", "OK", info);
    }

    public DWEAIResult getSupplementaryWorkReport(Map<String, String> headers, String messageBody) throws DWException {
        Map map = JSON.parseObject(messageBody, Map.class);
        Map<String, Object> workReportInfo = workReportService.getSupplementaryWorkReport(map);
        return new DWEAIResult("0", "0", "OK", workReportInfo);
    }
}
