package com.digiwin.athena.dtdapp.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.digiwin.athena.dtdapp.dao.st.EmployeeDAO;
import com.digiwin.athena.dtdapp.dao.st.OrganizationDAO;
import com.digiwin.athena.dtdapp.dao.st.StConfigDAO;
import com.digiwin.athena.dtdapp.pojo.dto.api.*;
import com.digiwin.athena.dtdapp.pojo.entity.st.Employee;
import com.digiwin.athena.dtdapp.pojo.entity.st.Organization;
import com.digiwin.athena.dtdapp.pojo.entity.st.StConfig;
import com.digiwin.athena.dtdapp.util.HttpUtil;
import com.digiwin.athena.dtdapp.util.LoginUserUtils;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.*;

@Service
@Slf4j
public class DtdappEocService {
    private static final String IAM_AP_TOKEN = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c";
    private static final String DEPT_INFO = "/api/eoc/v2/dept/list";
    private static final String EMPLOYEE_INFO = "/api/eoc/v2/emp/list";
    private static final String DEPT_EMPLOYEE_INFO = "/api/eoc/v2/dept/cascade";
    private static final String JOB_TYPE = "/api/eoc/v2/emp/type/find";
    private static final String STRONGHOLD = "/api/eoc/v2/corp/company/";
    private static final String Attribute = "/api/eoc/v2/emp/attribute/find";

    private final String TENANT_ID = "99990000";
    @Autowired
    RestTemplate restTemplate;
    @Value("${eocUrl}")
    private String eocUrl;
    @Autowired
    private DtdappIamService iamService;
    @Autowired
    private EmployeeDAO employeeDAO;
    @Autowired
    private OrganizationDAO organizationDAO;
    @Autowired
    private StConfigDAO stConfigDAO;

    /**
     * 根据empIds查询当前租户下多个员工的详细信息
     *
     * @throws Exception
     */
    public JSONArray getEmployeeInfo(List empId) throws Exception {
        String tenantToken = iamService.getTenantToken(TENANT_ID);

        HttpHeaders headers = new HttpHeaders();
        headers.add("Contect-Type", "application/json");
        headers.add("digi-middleware-auth-user", tenantToken);
        headers.add("digi-middleware-auth-app", IAM_AP_TOKEN);
//
        List<String> requestBody = new ArrayList<>();
//        requestBody.add("23117");
        requestBody.addAll(empId);

      // String jsonString = JSON.toJSONString(empId);

        HttpEntity<List<String>> requestEntity = new HttpEntity<>(requestBody, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(eocUrl + EMPLOYEE_INFO, HttpMethod.POST, requestEntity, Object.class);
        Object body = resEntity.getBody();


            String s = JSON.toJSONString(body);
            JSONObject jsonObject = JSONObject.parseObject(s);

        JSONArray jsonArray = jsonObject.getJSONArray("data");
        return jsonArray;
    }


    /**
     * 查询所有部门信息以及部门下所有员工的信息
     */
    public JSONArray getDeptEmployee(List<Api_Dept> deptList) throws Exception {
        String tenantToken = iamService.getTenantToken(TENANT_ID);
        Map headers = new HashMap<>();
        headers.put("digi-middleware-auth-user", tenantToken);
        headers.put("digi-middleware-data-mask", "false");
        headers.put("digi-middleware-auth-app", IAM_AP_TOKEN);

//        StConfig depts = stConfigDAO.getBaseMapper().selectOne(new QueryWrapper<StConfig>().lambda().eq(StConfig::getType, "depts"));
        String[] strings =  deptList.stream().map(Api_Dept::getId).toArray(String[]::new);
//        String[] strings = depts.getValue().split(",");
        HashMap<String, Object> params = new HashMap<>();
//        String split = depts.getValue();
//        List<String> strings = new ArrayList<>();
//        strings.add(split);
//        HashMap<String, Object> params = new HashMap<>();

        params.put("depts", strings);

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("pageNum", 1);
        requestMap.put("pageSize", 99999);
        requestMap.put("params", params);
        String jsonString = JSON.toJSONString(requestMap);

        String s = HttpUtil.sendGet(eocUrl + DEPT_EMPLOYEE_INFO, jsonString, headers);
        JSONObject jsonObject = JSON.parseObject(s);
        JSONArray jsonArray = jsonObject.getJSONObject("data").getJSONArray("list");
        return jsonArray;
    }


    /**
     * 获取所有部门及其子部门
     *
     * @throws Exception
     */
    public List<Api_Dept> getDeptInfo(String id) throws Exception {
        String tenantToken = iamService.getTenantToken(TENANT_ID);

        List<Api_Dept> apiDepts = new ArrayList<>();
        List<Api_Dept> apiDept = new ArrayList<>();
        Map headers = new HashMap<>();

        headers.put("digi-middleware-auth-user", tenantToken);
        headers.put("digi-middleware-auth-app", IAM_AP_TOKEN);

        StConfig dept = stConfigDAO.getBaseMapper().selectOne(new QueryWrapper<StConfig>().lambda().eq(StConfig::getType, "dept"));
        String[] split = dept.getValue().split(",");
        for (String s : split) {
            Map<String, Object> paramsMap = new HashMap<>();
            paramsMap.put("deptContent", s);
            paramsMap.put("countEmp", true);

            Map<String, Object> requestMap = new HashMap<>();
            requestMap.put("pageNum", "1");
            requestMap.put("pageSize", "99999");
            requestMap.put("params", paramsMap);
            String jsonString = JSON.toJSONString(requestMap);
            String forObject = HttpUtil.sendGet(eocUrl + DEPT_INFO, jsonString, headers);
            JSONObject jsonObject = JSON.parseObject(forObject);
            JSONArray jsonArray = jsonObject.getJSONObject("data").getJSONArray("list");
            apiDept = JSON.parseArray(JSON.toJSONString(jsonArray), Api_Dept.class);
            apiDepts.addAll(apiDept);
        }


        return apiDepts;
    }

    /**
     * 获取工种信息
     */
    public List<Api_Type> getJobType() throws Exception {
        String tenantToken = iamService.getTenantToken(TENANT_ID);
        Map headers = new HashMap<>();
        headers.put("digi-middleware-auth-user", tenantToken);
        headers.put("digi-middleware-data-mask", "false");
        headers.put("digi-middleware-auth-app", IAM_AP_TOKEN);

        HashMap<String, String> objectObjectHashMap = new HashMap<>();

        String s = HttpUtil.postByFormData(eocUrl + JOB_TYPE, headers, objectObjectHashMap);
        log.info(s);
        JSONObject jsonObject = JSON.parseObject(s);
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        List<Api_Type> apiType = JSON.parseArray(JSON.toJSONString(jsonArray), Api_Type.class);
        return apiType;


    }
    /**
     * 获取据点信息/api/eoc/v2/corp/company/{sid}/{level}
     */
    public List<Api_Stronghold> getCompany() throws Exception {

        String tenantToken = iamService.getTenantToken(TENANT_ID);
        Map headers = new HashMap<>();
        headers.put("Content-Type", "application/json");
        headers.put("digi-middleware-auth-user", tenantToken);
        headers.put("digi-middleware-auth-app", IAM_AP_TOKEN);

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("pageNum", "1");
        requestMap.put("pageSize", "99999");
        String jsonString = JSON.toJSONString(requestMap);
        //获取公司sid
        String apiUrl1 = eocUrl + STRONGHOLD;
        String forObject1 = HttpUtil.sendGet(apiUrl1, jsonString, headers);
        JSONObject jsonObject = JSON.parseObject(forObject1);
        JSONArray jsonArray1 = jsonObject.getJSONObject("data").getJSONArray("list");
        List<Api_Stronghold> apiStrongholds = JSON.parseArray(JSON.toJSONString(jsonArray1), Api_Stronghold.class);

        String apiUrl2 = eocUrl + STRONGHOLD + apiStrongholds.get(0).getSid() + "/" + 3;
        String forObject2 = HttpUtil.sendGet(apiUrl2, jsonString, headers);
        jsonObject = JSON.parseObject(forObject2);
        log.info("jsonObject={}",jsonObject);
        JSONArray jsonArray = jsonObject.getJSONObject("data").getJSONArray("list");
        List<Api_Stronghold> apiStrongholdS = JSON.parseArray(JSON.toJSONString(jsonArray), Api_Stronghold.class);
        return apiStrongholdS;
    }

    /**
     * 获取工种信息
     */
    public List<Api_Attribute> getAttribute() throws Exception {
        StConfig companySid = stConfigDAO.getBaseMapper().selectOne(new QueryWrapper<StConfig>().lambda().eq(StConfig::getType, "companySid"));

        String tenantToken = iamService.getTenantToken(TENANT_ID);
        Map headers = new HashMap<>();
        headers.put("Content-Type", "application/json");
        headers.put("digi-middleware-auth-user", tenantToken);
        headers.put("digi-middleware-auth-app", IAM_AP_TOKEN);

        HashMap<String, String> objectObjectHashMap = new HashMap<>();

        String forObject = HttpUtil.postByFormData(eocUrl+Attribute, headers,objectObjectHashMap );

        JSONObject jsonObject = JSON.parseObject(forObject);
        log.info("jsonObject={}",jsonObject);
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        List<Api_Attribute> apiAttributes = JSON.parseArray(JSON.toJSONString(jsonArray), Api_Attribute.class);
        return apiAttributes;
    }



    /**
     * 将部门信息插入报工组织表
     */
    public void insertDeptInfo() throws Exception {

        List<Api_Dept> depts = getDeptInfo(null);
        log.info("dept={}", depts.size());
        ArrayList<Organization> organizations = new ArrayList<>();
        int count = 0;
        List<Organization> allOrganizations = organizationDAO.getBaseMapper().selectList(new QueryWrapper<Organization>().lambda().eq(Organization::getTenantsid, LoginUserUtils.getTenantSid()));
        Map<String, Long> organizationMap = new HashMap<>();
        for (Organization organization : allOrganizations) {
            organizationMap.put(organization.getOrg_no(),organization.getId());
        }

        List<Api_Dept> deptList = getDeptInfo(null);
        Map<String, String> apiDeptMap = new HashMap<>();
        for (Api_Dept apiDept : deptList) {
            apiDeptMap.put(apiDept.getSid(), apiDept.getId());
        }

        for (Api_Dept apiDept : depts) {
            Organization organization = new Organization();
            if (organizationMap.containsKey(apiDept.getId())){
                organization.setId(organizationMap.get(apiDept.getId()));
            }
            organization.setOrg_no(apiDept.getId());
            organization.setOrg_name(apiDept.getName());
            organization.setOrg_level_id(apiDept.getLevelId());
            organization.setOrg_level(apiDept.getLevelName());
            //通过父id获取父部门id
            organization.setSuper_org_no(apiDeptMap.get(apiDept.getParentSid()));
            organization.setOrg_supervisor_id(apiDept.getDirectorId());
            organization.setOrg_supervisor(apiDept.getDirectorName());
            //TODO 状态默认有效  Y-有效 N-无效
            organization.setStatus("Y");
            organization.setCorp_id(apiDept.getCorpId());
            organization.setCorp_name(apiDept.getCorpName());
            organization.setType(apiDept.getCompany() ? 0 : 1);
            organization.setEmpCount(apiDept.getEmpCount());
            organization.setEmpEnabled(apiDept.getEmpEnabled());
            organization.setTenantsid(LoginUserUtils.getTenantSid());
            organizations.add(organization);

            if (organizations.size() % 10 == 0) {
                organizationDAO.saveOrUpdateBatch(organizations);
                //log.info("dept={}",organizations);
//                count = count + organizations.size();
//                organizations.clear();

            }
        }
        organizationDAO.saveOrUpdateBatch(organizations);
//        log.info("dept={}",organizations);
//        count = count + organizations.size();
//        log.info("count={}", count);

    }

    /**
     * 将员工插入
     */
    public void insertEmployeeInfo() throws Exception {
        StConfig dept = stConfigDAO.getBaseMapper().selectOne(new QueryWrapper<StConfig>().lambda().eq(StConfig::getType, "dept"));

        //获取部门
        List<Api_Dept> deptList = getDeptInfo(null);
        HashMap<String, String> deptMap = new HashMap<>();
        HashMap<String, String> apiDeptMap = new HashMap<>();
        for (Api_Dept apiDept : deptList) {
            deptMap.put(apiDept.getDirectorUserId(),apiDept.getDirectorUserName());
            apiDeptMap.put(apiDept.getId(),apiDept.getDirectorId());
        }
        //获取工种
        List<Api_Type> jobTypeList = getJobType();
        HashMap<Long, String> typeMap = new HashMap<>();
        for (Api_Type apiType : jobTypeList) {
              typeMap.put(apiType.getSid(),apiType.getName());
        }
        //获取据点
        List<Api_Stronghold> apiStrongholdList = getCompany();
        HashMap<String, Api_Stronghold> strongholdMap = new HashMap<>();
        for (Api_Stronghold apiStronghold : apiStrongholdList) {
            strongholdMap.put(apiStronghold.getSid(),apiStronghold);
        }
        //获取员工属性
        List<Api_Attribute> apiAttributeList = getAttribute();
        HashMap<String, Api_Attribute> attributeMap = new HashMap<>();
        for (Api_Attribute api_attribute : apiAttributeList) {
            attributeMap.put(api_attribute.getSid(),api_attribute);
        }
        List<Employee> allEmployees =new ArrayList<>();
        Map<String,Employee> employeeMap;
        //所有鼎捷云上的员工
        Set<String> digiwinCloudEmps = new HashSet<>();

        JSONArray jsonArray = getDeptEmployee(deptList);
        // 遍历list数组，并获取每个对象的emps数组
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject listItem = jsonArray.getJSONObject(i);
            JSONArray empsArray = listItem.getJSONArray("emps");
            List<Api_Dept_Employee> apiEmployees1 = JSON.parseArray(JSON.toJSONString(empsArray), Api_Dept_Employee.class);
            // 遍历emps数组，并转换为Emp对象
            ArrayList<Employee> employees = new ArrayList<>();
            ArrayList<Object> empIdList = new ArrayList<>();
            log.info("empsArray.size()={}", empsArray.size());
            int count = 0;
            //得到所有员工
            allEmployees = employeeDAO.getBaseMapper().selectList(new QueryWrapper<Employee>().lambda().eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
            employeeMap = new HashMap<>();
            for (Employee employee : allEmployees) {
                employeeMap.put(employee.getEmployee_no(),employee);
            }

            for (Api_Dept_Employee emp : apiEmployees1) {
                empIdList.add(emp.getId());
                digiwinCloudEmps.add(emp.getId());
                if (empIdList.size() % 100 == 0) {
                    JSONArray employeeInfo = getEmployeeInfo(empIdList);
                    List<Api_Employee> apiEmployees = JSON.parseArray(JSON.toJSONString(employeeInfo), Api_Employee.class);
                    for (Api_Employee apiEmployee : apiEmployees) {
                        Employee employee = new Employee();
                        //取符合查询条件的部门
                        loop: for (Api_EmployeeDepts employeeDept : apiEmployee.getDepts()) {
                            String[] split = dept.getValue().split(",");
                            for (String s : split) {
                                int length = s.length();
                                String substring = employeeDept.getId().substring(0, length);
                                if (s.equals(substring)) {
                                    employee.setOrg_no(employeeDept.getId());
                                    break loop;
                                }
                            }
                        }
                        //更新
                        if(employeeMap.containsKey(apiEmployee.getId())){
                            employee.setId(employeeMap.get(apiEmployee.getId()).getId());
                            if(StringUtils.isEmpty(employeeMap.get(apiEmployee.getId()).getApproval_no())){
                                employee.setApproval_no(apiDeptMap.get(employee.getOrg_no()));
                            }else {
                                employee.setApproval_no(employeeMap.get(apiEmployee.getId()).getApproval_no());
                            }
                        }else {
                            //插入
                            employee.setNeed_report_work(deptMap.containsKey(apiEmployee.getId()) ? false : true);
                            employee.setReport_frequency("D");
                            employee.setApproval_no(apiDeptMap.get(employee.getOrg_no()));
                        }

                        employee.setEmployee_no(apiEmployee.getId());
                        employee.setEmployee_name(apiEmployee.getName());
                        employee.setEmail(apiEmployee.getEmail());

                        employee.setTitle(apiEmployee.getDuties().get(0).getName());
                        employee.setQuitDate(apiEmployee.getQuitDate());
                        employee.setType(typeMap.get(apiEmployee.getTypeSid()));
                        employee.setStronghold(strongholdMap.get(apiEmployee.getStrongholdSid()).getName());
                        employee.setEmployee_attributes(attributeMap.get(apiEmployee.getAttributeSid()).getName());

                        String id = strongholdMap.get(apiEmployee.getStrongholdSid()).getId().substring(0,2);
                        switch (id){
                            case "C0" :  employee.setArea("CN"); break;
                            case "T0" :  employee.setArea("TW"); break;
                            default: employee.setArea("OTHER");
                        }
                        employee.setStatus(apiEmployee.getStatus()?"Y":"N");
                        employee.setTenantsid(LoginUserUtils.getTenantSid());
                        employees.add(employee);
                    }
                    employeeDAO.saveOrUpdateBatch(employees);
                    //log.info("list={}",employees);
                    employees.clear();
                    empIdList.clear();

                }
            }
            allEmployees = employeeDAO.getBaseMapper().selectList(new QueryWrapper<Employee>().lambda().eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
             employeeMap = new HashMap<>();
            for (Employee employee : allEmployees) {
                employeeMap.put(employee.getEmployee_no(),employee);
            }

            JSONArray employeeInfo = getEmployeeInfo(empIdList);
            List<Api_Employee> apiEmployees = JSON.parseArray(JSON.toJSONString(employeeInfo), Api_Employee.class);
            for (Api_Employee apiEmployee : apiEmployees) {
                Employee employee = new Employee();
                //取符合查询条件的部门
                loop : for (Api_EmployeeDepts employeeDept : apiEmployee.getDepts()) {
                    String[] split = dept.getValue().split(",");
                    for (String s : split) {
                        int length = s.length();
                        String substring = employeeDept.getId().substring(0, length);
                        if (s.equals(substring)) {
                            employee.setOrg_no(employeeDept.getId());
                            break loop;
                        }
                    }
                }
                //更新
                if(employeeMap.containsKey(apiEmployee.getId())){
                    employee.setId(employeeMap.get(apiEmployee.getId()).getId());

                    if(StringUtils.isEmpty(employeeMap.get(apiEmployee.getId()).getApproval_no())){
                        employee.setApproval_no(apiDeptMap.get(employee.getOrg_no()));
                    }else {
                        employee.setApproval_no(employeeMap.get(apiEmployee.getId()).getApproval_no());
                    }
                }else {
                    //插入
                    employee.setNeed_report_work(deptMap.containsKey(apiEmployee.getId()) ? false : true);
                    employee.setReport_frequency("D");
                    employee.setApproval_no(apiDeptMap.get(employee.getOrg_no()));
                }
                employee.setEmployee_no(apiEmployee.getId());
                employee.setEmployee_name(apiEmployee.getName());
                employee.setEmail(apiEmployee.getEmail());

                employee.setTitle(apiEmployee.getDuties().get(0).getName());
                employee.setQuitDate(apiEmployee.getQuitDate());
                employee.setType(typeMap.get(apiEmployee.getTypeSid()));
                String stronghold = apiEmployee.getStrongholdSid();
                log.info("a={}",stronghold);
                employee.setStronghold(strongholdMap.get(apiEmployee.getStrongholdSid()).getName());
                employee.setEmployee_attributes(attributeMap.get(apiEmployee.getAttributeSid()).getName());

                String id = strongholdMap.get(apiEmployee.getStrongholdSid()).getId().substring(0,2);
                switch (id){
                    case "C0" :  employee.setArea("CN"); break;
                    case "T0" :  employee.setArea("TW"); break;
                    default: employee.setArea("OTHER");
                }
                employee.setStatus(apiEmployee.getStatus()?"Y":"N");
                employee.setTenantsid(LoginUserUtils.getTenantSid());
                employees.add(employee);
            }
            employeeDAO.saveOrUpdateBatch(employees);

//            log.info("list={}",employees);
//            count = count + employees.size();
//           log.info("count={}", count);
        }
        List<Employee> quitEmployees = new ArrayList<>();
        for (Employee employee : allEmployees) {
            if(!digiwinCloudEmps.contains(employee.getEmployee_no())){
                employee.setStatus("N");
                quitEmployees.add(employee);
            }
        }
        employeeDAO.updateBatchById(quitEmployees);
    }

    /**
     * 获取员工信息数据结构
     * */
    public Map<String,List<Api_Employee>> getApiEmployee(Integer batchSize) throws Exception{
        List<Api_Dept> deptList = getDeptInfo(null);
        JSONArray deptJson = getDeptEmployee(deptList);
        Map<String, List<Api_Employee>> result = new HashMap<>();
        // 遍历list数组，并获取每个对象的emps数组
        if (Objects.nonNull(deptJson) && deptJson.size() > 0) {
            for (int i = 0; i < deptJson.size(); i++) {
                JSONObject listItem = deptJson.getJSONObject(i);
                if(Objects.isNull(listItem)){
                    continue;
                }
                JSONArray empsArray = listItem.getJSONArray("emps");
                List<Api_Dept_Employee> apiEmployees = JSON.parseArray(JSON.toJSONString(empsArray), Api_Dept_Employee.class);
                // 遍历emps数组，并转换为Emp对象
                ArrayList<Object> empIdList = new ArrayList<>();
                log.info("empsArray.size()={}", empsArray.size());

                for (Api_Dept_Employee emp : apiEmployees) {
                    empIdList.add(emp.getId());
                }

                List<List<Object>> batches = splitListIntoBatches(empIdList, batchSize);
                List<Api_Employee> resultList = new ArrayList<>();
                for (List<Object> batch : batches) {
                    JSONArray employeeInfo = getEmployeeInfo(batch);
                    resultList.addAll(JSON.parseArray(JSON.toJSONString(employeeInfo), Api_Employee.class));
                }
                result.put(listItem.getString("id"),resultList);
            }
        }

        return result;
    }


    //分批处理
    private   <T> List<List<T>> splitListIntoBatches(List<T> originalList, int batchSize) {
        List<List<T>> batches = new ArrayList<>();

        for (int i = 0; i < originalList.size(); i += batchSize) {
            int end = Math.min(i + batchSize, originalList.size());
            batches.add(originalList.subList(i, end));
        }

        return batches;
    }
}
