package com.digiwin.athena.dtdapp.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class DtdappIamService {

    @Autowired
    RestTemplate restTemplate;


    @Value("${iamUrl}")
    private String iamUrl;

    @Value("${iamApToken}")
    private String iamApToken;

    private final String LOGIN = "/api/iam/v2/identity/login/internal";

    private static final String integrationInternalPasswordHash = "6826CC688C4AF1BD0A8DDA2DBDF8897B";

    public String getTenantToken(String tenantId) throws Exception{
        Object login = login(tenantId);
        JSONObject loginJsonObject = JSON.parseObject(JSON.toJSONString(login));
        String token = null;
        if(StringUtils.equals(tenantId, loginJsonObject.getString("tenantId"))){
            token = loginJsonObject.getString("token");
        }
        return token;
    }
    public Object login(String tenantId) throws Exception{
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", null);
        headers.add("digi-middleware-auth-app", iamApToken);

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("tenantId", tenantId);
        requestMap.put("userId", "integration");
        requestMap.put("passwordHash", integrationInternalPasswordHash);
        requestMap.put("identityType", "token");
        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + LOGIN, HttpMethod.POST, requestEntity, Object.class);
        Object body = resEntity.getBody();
        return body;
    }
}
